<!DOCTYPE html>
<html lang="en">

<?php echo $__env->make('head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body>
<?php echo $__env->make('messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- Whatsapp Buttton Started -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
  <a href="https://api.whatsapp.com/send?phone=919495119446&text=Donate%20blood%20and%20inspire%20others..." class="float" target="_blank">
      <i class="fa fa-whatsapp my-float"></i>
  </a>
  
  <!-- Whatsapp Buttton Ended -->

  <!--preloader start-->
  <div class="preloader">
    <h1>Lifeflow Donors</h1>
    <div class="preload-progress">
      <span></span>
    </div>
  </div>
  <!--preloader end-->

  <!-- scroll to top -->
  <div class="progress-wrap cursor-pointer active-progress">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
      <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
        style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 221.377;">
      </path>
    </svg>
  </div>
  <!-- scroll to top -->

  <!-- header start -->
  <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- header end -->

  <!-- breadcrumb start -->
  <div class="breadcrumb_section overflow-hidden ptb-150">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-6 col-md-8 col-sm-10 col-12 text-center">
          <h2>Request Register</h2>
          <ul>
            <li><a href="<?php echo e(url('/'), false); ?>">Home</a></li>
            <li class="active">Request Register</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <!-- breadcrumb end -->

<!-- request & appoinment start -->
<section class="request">
  <div class="container">
    <div class="row">
      <div class="col-xl-6 col-lg-6 col-md-6 col-12 mb-4 mb-xl-0 mb-lg-0">
        <div class="current1">
          <img src="<?php echo e(asset('/assets/images/aa.png'), false); ?>" alt="">
        </div>
      </div>
      <div class="col-xl-6 col-lg-6 col-md-6 col-12">
        <div class="appointment">
          <h4>Register Blood Request</h4>

          <form action="<?php echo e(route('donors'), false); ?>" method="POST" id = "save-request" class="row hm1_contact_form"> 
              <?php echo csrf_field(); ?>
            <div class="col-12 mb-4">
              <select class="form-select" name = "district">
                <option value="">Select District</option>
                <option value="Alappuzha">Alappuzha</option>
                <option value="Ernakulam">Ernakulam</option>
                <option value="Idukki">Idukki</option>
                <option value="Kollam">Kollam</option>
                <option value="Kannur">Kannur</option>
                <option value="Kasaragod">Kasaragod</option>
                <option value="Kottayam">Kottayam</option>
                <option value="Kozhikode">Kozhikode</option>
                <option value="Malappuram">Malappuram</option>
                <option value="Palakkad">Palakkad</option>
                <option value="Pathanamthitta">Pathanamthitta</option>
                <option value="Thrissur">Thrissur</option>
                <option value="Thiruvanathapuram">Thiruvanathapuram</option>
                <option value="Wayanad">Wayanad</option>
                <option value="Outside Kerala/Abroad">Outside Kerala/Abroad</option>
              </select>
            </div>
            <div class="col-xl-6 col-12 mb-4">
              <input type="text" class="form-control" placeholder="Patient Name" name = "PatientName" required="">
            </div>
            <div class="col-xl-6 col-12 mb-4">
              <input type="text" class="form-control" placeholder="Hospital Name" name = "HospitalName" required="">
            </div>
            <div class="col-xl-6 col-12 mb-4">
              <input type="text" class="form-control" placeholder="Admission No" name = "AdmsnNo">
            </div>
            <div class="col-xl-6 col-12 mb-4">
              <input type="number" class="form-control" placeholder="Pincode" name = "pincode" maxlength="6">
            </div>
            <div class="col-xl-6 col-12 mb-4">
              <input type="number" class="form-control" placeholder="Phone No" name = "number" required="">
            </div>
            <div class="col-xl-6 col-12 mb-4">
              <input type="number" class="form-control" placeholder="Whatsapp No" name = "whatsapp">
            </div>
            <div class="col-12 mb-4">
              <input type="email" class="form-control" placeholder="Email" name = "email" required="">
            </div>
            <div class="col-12 mb-4">
              <select class="form-select" name = "bloodgroup" required="">
                <option value="">Select Blood Group</option>
                <option value="O+">O+</option>
                <option value="O-">O-</option>
                <option value="A+">A+</option>
                <option value="A-">A-</option>
                <option value="A-">A-</option>
                <option value="A-">A-</option>
                <option value="AB+">AB+</option>
                <option value="AB-">AB-</option>
                <option value="HH/Bombay">HH/Bombay</option>
              </select>
            </div>
            <div class="col-12 mb-4">
              <input type="date" class="form-control" placeholder="Blood Request date" name = "request_date" required="">
            </div>
            <div class="col-12 mb-4">
              <input type="text" class="form-control" placeholder="Required Unit" name = "unit">
            </div>
            <div class="col-12 mb-4">
              <select class="form-select" name = "request_type" required="">
                <option value="">Request Type Select</option>
                <option value="B">Blood</option>
                <option value="P">Platelet</option>
              </select>
            </div>
            <div class="col-12">
              <button type="submit" class="red_btn">Submit Now</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- request & appoinment end -->

 <!-- footer section start -->
 <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- footer section end -->

<!-- mobile menu -->
<?php echo $__env->make('mobilemenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- script -->
<?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>

   $('#save-request').validate({
      rules: {
        PatientName: {
          required: true,
        },
        email: {
          required: true,
        },
        number: {
          required: true,
        },
        bloodgroup: {
          required: true,
        },
        HospitalName: {
          required: true,
        },
        request_type: {
          required: true,
        },
        pincode: {
          required: true,
          digits: true,   // Ensures that only digits are entered
          maxlength: 6,   // Limits the length to 6 digits
        }
      },
   });
</script>
</body>

</html><?php /**PATH D:\Life Flow Donors\Life\resources\views/donors.blade.php ENDPATH**/ ?>