<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blood_requests', function (Blueprint $table) {
            $table->id();
            $table->string('patiientname');
            $table->string('hsptl_name');
            $table->string('email');
            $table->string('adsn_no')->nullable();
            $table->string('blood_grp');
            $table->string('pincode',6)->nullable();
            $table->date('phone_no',20)->nullable();
            $table->string('whatsapp', 20);
            $table->date('blood_rqst_date')->nullable();
            $table->String('rqur_unt')->nullable();
            $table->text('requird_typ')->nullable();
            $table->string('city', 20);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blood_requests');
    }
};
