<?php

namespace App\Admin\Controllers;

use App\models\Hospital;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;

class HospitalController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Hospital';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Hospital());

        $grid->column('id', __('Id'));
        $grid->column('hsptlname', __('Hospital Name'));
        $grid->column('image', __('Image'))->image('',60,60);
        $grid->column('working_hours', __('Working hours'));
        $grid->column('address', __('Address'));
        $grid->column('phn_number', __('Contact Number'));
        $grid->column('url', __('Url'));
      
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Hospital::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('hsptlname', __('Hospital Name'));
        $show->field('image', __('Image'));
        $show->field('working_hours', __('Working hours'));
        $show->field('address', __('Address'));
        $show->field('phn_number', __('Contact Number'));
        $show->field('url', __('Url'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Hospital());

        $form->text('hsptlname', __('Hospital Name'));
        $form->cropper('image', __('Image'))->cRatio('368','276');
        $form->text('working_hours', __('Working hours'));
        $form->text('address', __('Address'));
        $form->text('phn_number', __('Contact Number'));
        $form->url('url', __('Url'));

        return $form;
    }
}
