<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\BloodRequestController;
use App\Http\Controllers\BloodbankController;
use App\Models\Banner;
use App\Models\Hospital;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('welcome', function () {
    return view('welcome');
});
// Route::get('/', function () {
//     $services = Category::where('active', 1)
//             ->latest()
//             ->take(6)
//             ->get();
//             $notif = Notifications::where('active', 1)->get();
//         $notifications = Notif::where('active', 1)->get();
//         $banner = Post::where('active', 1)->get();
//         return view('index', compact(['services', 'notifications','banner','notif']));
//     });

Route::get('/', function () {
    $banner = Banner::where('active', 1)->get();
    return view('index', compact(['banner']));
});
Route::get('about-us', function () {
    return view('about-us');
});
Route::get('messagefromdirector', function () {
    return view('messagefromdirector');
});
Route::get('contact', function () {
    return view('contact');
});
Route::get('faq', function () {
    return view('faq');
});

Route::get('services', function () {
    return view('services');
});
Route::get('hospitals', function () {
    $hsptl = Hospital::all();
    return view('hospitals',compact(['hsptl']));
});
Route::get('kerala', function () {
    return view('kerala');
});
Route::get('tamilnadu', function () {
    return view('tamilnadu');
});
Route::get('bengaluru', function () {
    return view('bengaluru');
});
Route::get('declaration', function () {
    return view('declaration');
});
Route::get('register', function () {
    return view('register');
});
Route::get('donorslist', 'BloodRequestController@donorsList')->name('donorslist');

Route::get('kerala/{district}',[BloodbankController::class, 'index'])->name('getstate');

Route::get('donors', function () {
    return view('donors');
});

Route::post('register', [RegisterController::class, 'save'])->name('save');

Route::post('donors', [BloodRequestController::class, 'save'])->name('donors');

Route::post('contact', [ContactController::class,'send']);
