<?php

use Illuminate\Routing\Router;

Admin::routes();

Route::group([
    'prefix'        => config('admin.route.prefix'),
    'namespace'     => config('admin.route.namespace'),
    'middleware'    => config('admin.route.middleware'),
    'as'            => config('admin.route.prefix') . '.',
], function (Router $router) {
    $router->get('/api/city', 'BloodBankController@city');
    $router->get('/', 'HomeController@index')->name('home');
    $router->resource('register', RegistrationController::class);
    $router->resource('bloodrequests', BloodController::class);
    //$router->resource('hospital', HospitalController::class);
    $router->resource('hospitals', HospitalController::class);
    $router->resource('banner', BannerController::class);
    $router->resource('ads', AdsController::class);
    $router->resource('bloodbank', BloodBankController::class);
});
