<?php

namespace App\Admin\Controllers;

use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Register;

class RegistrationController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Registration Details';

    /**
     * Make a grid builder.
     *
     * @return Grid
     
     */
    protected function grid()
    {
        $grid = new Grid(new Register);

        $grid->column('id', __('SL.NO'))->sortable();
        $grid->column('firstname', __('First Name'));
        $grid->column('lastname', __('LastName'));
        $grid->column('email', __('Email'));
        $grid->column('blood_group', __('Blood Group'));
        $grid->column('last_donate', __('Last Donate Date'));
        $grid->column('phn_number', __('Contact Number'));
        $grid->column('address', __('Address'));
        // $grid->column('marital_status', __('Marital Status'));
        // $grid->column('gender', __('Gender'));
        $grid->column('city', __('City'));
        $grid->column('state', __('State'));
        $grid->column('country', __('Country'));
        $grid->column('health_issues', __('Health issues'));
    
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed   $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Register::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('firstname', __('First Name'));
        $show->field('lastname', __('LastName'));
        $show->field('email', __('Email'));
        $show->field('blood_group', __('Blood Group'));
        $show->field('last_donate', __('Last Donate Date'));
        $show->field('phn_number', __('Contact Number'));
        $show->field('address', __('Address'));
        $show->field('marital_status', __('Marital Status'));
        $show->field('gender', __('Gender'));
        $show->field('city', __('City'));
        $show->field('state', __('State'));
        $show->field('country', __('Country'));
        $show->field('health_issues', __('Health issues'));
        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Register);

        $form->display('id', __('ID'));
        
        $form->text('firstname', __('First Name'))->setWidth(4, 2);
        $form->text('lastname', __('LastName'))->setWidth(4, 2);
        $form->text('email', __('Email'))->setWidth(4, 2);
        $form->text('blood_group', __('Blood Group'))->setWidth(4, 2);
        $form->date('last_donate', __('Last Donate Date'))->setWidth(4, 2);
        $form->mobile('phn_number', __('Contact Number'))->setWidth(4, 2);
        $form->text('address', __('Address'))->setWidth(4, 2);
        $form->text('marital_status', __('Marital Status'))->setWidth(4, 2);
        $form->select('gender', __('Gender'))->options(['Male'=>'Male','Female'=>'Female','Others'=>'Others'])->setWidth(4, 2);
        $form->text('city', __('City'))->setWidth(4, 2);
        $form->text('state', __('State'))->setWidth(4, 2);
        $form->text('country', __('Country'))->setWidth(4, 2);
        $form->text('health_issues', __('Health issues'));
        
        return $form;
    }
}
