<?php


namespace App\Admin\Controllers;

use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Illuminate\Http\Request;
use App\Models\BloodRequest;

class BloodController extends AdminController
{
    protected $title = 'BloodRequest';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new BloodRequest());

        $grid->column('id', __('Sl.No'));
        $grid->column('patiientname', __('Patiient Name'));
        $grid->column('hsptl_name', __('Hospital Name'));
        $grid->column('email', __('Email'));
        $grid->column('adsn_no', __('Admission No'));
        $grid->column('blood_grp', __('Blood group'));
        $grid->column('pincode', __('Pincode'));
        $grid->column('city', __('City'));
        $grid->column('phone_no', __('Phone no'));
        $grid->column('whatsapp', __('Whatsapp'));
        $grid->column('blood_rqst_date', __('Blood Request date'));
        $grid->column('rqur_unt', __('Require unt'));
        $grid->column('requird_typ', __('Required type'))->display(function ($value) {
            return ($value == 'B') ? 'Blood' : (($value == 'P') ? 'Platelet' : $value);
        });
       
        $grid->disableCreateButton();

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(BloodRequest::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('patiientname', __('Patiientname'));
        $show->field('hsptl_name', __('Hsptl name'));
        $show->field('email', __('Email'));
        $show->field('adsn_no', __('Adsn no'));
        $show->field('blood_grp', __('Blood grp'));
        $show->field('pincode', __('Pincode'));
        $show->field('phone_no', __('Phone no'));
        $show->field('whatsapp', __('Whatsapp'));
        $show->field('blood_rqst_date', __('Blood rqst date'));
        $show->field('rqur_unt', __('Rqur unt'));
        $show->field('requird_typ', __('Requird typ'));
        $show->field('city', __('City'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new BloodRequest());

        $form->text('patiientname', __('Patiientname'));
        $form->text('hsptl_name', __('Hsptl name'));
        $form->email('email', __('Email'));
        $form->text('adsn_no', __('Adsn no'));
        $form->text('blood_grp', __('Blood grp'));
        $form->text('pincode', __('Pincode'));
        $form->text('phone_no', __('Phone no'));
        $form->text('whatsapp', __('Whatsapp'));
        $form->date('blood_rqst_date', __('Blood rqst date'))->default(date('Y-m-d'));
        $form->text('rqur_unt', __('Rqur unt'));
        $form->textarea('requird_typ', __('Requird typ'));
        $form->text('city', __('City'));

        return $form;
    }
}
