<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\models\States;
use App\models\City;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\BloodBank;

class BloodBankController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'BloodBank Details';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new BloodBank());

        $grid->column('id', __('Id'));
        $grid->column('bloodbankname', __('Blood bank Name'));
        $grid->column('working_hours', __('Working hours'));
        $grid->column('address', __('Location'));
        $grid->column('phn_number', __('Contact Number'));
        $grid->column('url', __('Url'));
      
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(BloodBank::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('bloodbankname', __('Blood bank Name'));
        $show->field('working_hours', __('Working hours'));
        $show->field('address', __('Location'));
        $show->field('phn_number', __('Contact Number'));
        $show->field('url', __('Url'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new BloodBank());

        $form->text('bloodbankname', __('Blood bank Name'))->rules('required');
        $form->text('working_hours', __('Working hours'))->rules('required');
        $form->select('state_id', __('State'))
        ->options(States::all()->pluck('state', 'id'))
        ->setWidth(4, 2)
        ->load('city_id', '/admin/api/city'); 

        $form->select('city_id', __('City Name'))->setWidth(4, 2);

        $form->text('address', __('Location'))->rules('required');
        $form->text('phn_number', __('Contact Number'))->rules('required');
        $form->url('url', __('Url'))->rules('required');

        return $form;
    }

    public function city(Request $request)
{

  $state_id = $request->get('q');
  $City = City::where('state_id', $state_id)->pluck('city_name', 'id');
    return $City;
  
}
}
