<?php

namespace App\Admin\Controllers;
use App\Models\Constant;
use App\Models\Banner;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Illuminate\Support\Facades\Hash;

class BannerController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Banner';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
      
        $grid = new Grid(new Banner());
        $grid->column('id',__('SL.No'));
   
        $grid->column('PostHeading',__('PostHeading'))->display(function ($descrp) {
            return strip_tags($descrp);
        });
        $grid->column('imageforwebsite',__('imageforwebsite'))->image('',60,60);
        $grid->column('description',__('Description'))->display(function ($descrp) {
            return strip_tags($descrp);
        });
        $grid->column('sortorder',__('Order'));
          $grid->column('Active',__('Active'))->display(function ($Active) {
           if($Active ===Constant::STATUS_NO){
               return "Inactive";
           }else{
               return "Active";
           }});
    

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Banner::findOrFail($id));



        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {

        $form = new Form(new Banner());
    
        $form->ckeditor('PostHeading',__('PostHeading'))->options(['lang' => 'fr', 'height' => 200]);
        $form->ckeditor('description',__('Description'))->options(['lang' => 'fr', 'height' => 200]);
        $form->cropper('imageforwebsite','Image for Website')->cRatio('1520','705')->move('banner/websiteimage')->rules('required');
        $form->text('sortorder',__('Order'))->setWidth(2, 2)->rules('required|numeric');
        $form->switch('Active',__('Active'))->default('1');
        
   


       
        return $form;
    }
}
