<?php

namespace App\Admin\Controllers;
use App\Models\Constant;
use App\Models\Ads;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Illuminate\Support\Facades\Hash;

class AdsController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Advertisements.';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
      
        $grid = new Grid(new Ads());
        $grid->column('id',__('SL.No'));
   
        $grid->column('adsimage',__('image for Ads'))->image('',60,60);
        $grid->column('description',__('Description'))->display(function ($descrp) {
            return strip_tags($descrp);
        });
        $grid->column('url', __('Url'));
        $grid->column('sortorder',__('Order'));
          $grid->column('Active',__('Active'))->display(function ($Active) {
           if($Active ===Constant::STATUS_NO){
               return "Inactive";
           }else{
               return "Active";
           }});
    

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Ads::findOrFail($id));



        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {

        $form = new Form(new Ads());
    
        $form->ckeditor('description',__('Description'))->options(['lang' => 'fr', 'height' => 200]);
        $form->cropper('adsimage','Image for ADS')->cRatio('279','279')->move('Ads')->rules('required');
        $form->url('url', __('Url'));
        $form->text('sortorder',__('Order'))->setWidth(2, 2)->rules('required|numeric');
        $form->switch('Active',__('Active'))->default('1');
        
   


       
        return $form;
    }
}
