<!DOCTYPE html>
<html lang="en">

<?php echo $__env->make('head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<body>

  <!-- Whatsapp Buttton Started -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
  <a href="#" class="float" target="_blank">
    <i class="fa fa-whatsapp my-float"></i>
  </a>

  <!-- Whatsapp Buttton Ended -->

  <!--preloader start-->
  <div class="preloader">
    <h1>Lifeflow Donors</h1>
    <div class="preload-progress">
      <span></span>
    </div>
  </div>
  <!--preloader end-->

  <!-- scroll to top -->
  <div class="progress-wrap cursor-pointer active-progress">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
      <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
        style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 221.377;">
      </path>
    </svg>
  </div>
  <!-- scroll to top -->

  <!-- header start -->
  <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- breadcrumb start -->
  <div class="breadcrumb_section overflow-hidden ptb-150">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-6 col-md-8 col-sm-10 col-12 text-center">
          <h2>About Us</h2>
          <ul>
            <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="active">About Us</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <!-- breadcrumb end -->

  <!-- help the people start -->
  <section class="help_people ptb-115">
    <div class="container">
      <div class="row align-items-center g-lg-5 g-xl-5 g-xxl-5">
        <div class="col-xl-6 col-lg-6 col-md-6 col-12 mb-5 mb-xl-0 mb-lg-0 mb-md-0">
          <div class="help_wrap position-relative">
            <img src="assets/images/a2.png" class="help_3" alt="" />
            <img src="assets/images/j.jpg" class="help_4" alt="" />
          </div>
        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-12">
          <div class="help_content">
            <p class="red_color">About Us</p>
            <h2>Welcome to <span style="color: #ea062b;">Lifeflow Donors</span></h2>
            <p>Welcome to <b>Lifeflow Donors</b>, a dedicated group of passionate individuals committed to
              making a positive impact on the well-being of our community through the invaluable act of blood donation.
              Our team is driven by a shared vision of creating a healthier and more resilient society, one donation at
              a time.</p>
            <p>Our commitment to the community drives us to facilitate the noble act of blood donation. Established with
              the mission to bridge the gap between those in need and compassionate donors, we strive to create a
              reliable and accessible platform for giving the gift of life. </p>

          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- help the people end -->

  <!-- counter start -->
  <div class="km__counterup___section">
    <div class="container">
      <div class="row g-4 justify-content-center">
        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4 mb-xl-0 mb-lg-0 mb-md-0">
          <ul class="km__counterup___box text-center">
            <li class="h1 counter mb-30"><span class="count">25</span></li>
            <li class="counter__content">Years of Experience</li>
          </ul>
        </div>
        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4 mb-xl-0 mb-lg-0 mb-md-0">
          <ul class="km__counterup___box text-center">
            <li class="h1 counter mb-30"><span class="count">430</span></li>
            <li class="counter__content">Blood Donations</li>
          </ul>
        </div>
        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4 mb-xl-0 mb-lg-0 mb-md-0">
          <ul class="km__counterup___box text-center">
            <li class="h1 counter mb-30"><span class="count">90</span></li>
            <li class="counter__content">Total Awards</li>
          </ul>
        </div>
        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12">
          <ul class="km__counterup___box text-center">
            <li class="h1 counter mb-30"><span class="count">35</span></li>
            <li class="counter__content">Blood Cooperations</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <!-- counter end -->

  <!-- what we do start -->
  <section class="whatdo ptb-115">
    <div class="container">
      <div class="row mb-5">
        <div class="col-12">
          <div class="common_title text-center">
            <p>what we do</p>
            <h2>Donation Process</h2>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <div class="what_progress">
            <ul>
              <img src="assets/images/p_line.png" class="progress_line" alt="" />
              <li>
                <div class="row">
                  <div class="col-xl-6 col-lg-6 col-md-7 col-sm-9 col-12">
                    <div class="progress_content d-flex align-items-center gap-xl-5 gap-lg-5 gap-md-4 gap-sm-3 gap-3">
                      <div class="p_content_left">
                        <h5>Registration</h5>
                        <p>
                          We’ll sign you in and go over basic eligibility.
                          You’ll be asked to show ID, such as your driver’s license.
                          You’ll read some information about donating blood.
                        </p>
                      </div>
                      <span class="progress_number">01</span>
                    </div>
                  </div>
                </div>
              </li>
              <li>
                <div class="row justify-content-end">
                  <div class="col-xl-6 col-lg-6 col-md-7 col-sm-9 col-12">
                    <div class="progress_content d-flex align-items-center gap-xl-5 gap-lg-5 gap-md-4 gap-sm-3 gap-3">
                      <span class="progress_number">02</span>
                      <div class="p_content_left p_content_right">
                        <h5>Health History</h5>
                        <p>
                          You’ll answer a few questions about your health history and places you’ve traveled, during a
                          private and confidential interview.
                          You’ll tell us about any prescription and/or over the counter medications that may be in your
                          system.
                        </p>
                      </div>
                    </div>
                  </div>
                </div>
              </li>
              <li>
                <div class="row">
                  <div class="col-xl-6 col-lg-6 col-md-7 col-sm-9 col-12">
                    <div class="progress_content d-flex align-items-center gap-xl-5 gap-lg-5 gap-md-4 gap-sm-3 gap-3">
                      <div class="p_content_left">
                        <h5>Donation</h5>
                        <p>
                          If you’re donating whole blood, we’ll cleanse an area on your arm and insert a brand new
                          sterile needle for the blood draw. (This feels like a quick pinch and is over in seconds.)
                          Other types of donations, such as platelets, are made using an apheresis machine which will be
                          connected to both arms.
                        </p>
                      </div>
                      <span class="progress_number">03</span>
                    </div>
                  </div>
                </div>
              </li>
              <li>
                <div class="row justify-content-end">
                  <div class="col-xl-6 col-lg-6 col-md-7 col-sm-9 col-12">
                    <div class="progress_content d-flex align-items-center gap-xl-5 gap-lg-5 gap-md-4 gap-sm-3 gap-3">
                      <span class="progress_number">04</span>
                      <div class="p_content_left p_content_right">
                        <h5>Refresh &amp; Recovery</h5>
                        <p>
                          After donating blood, you’ll have a snack and something to drink in the refreshment area.
                          You’ll leave after 10-15 minutes and continue your normal routine.
                        </p>
                      </div>
                    </div>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- what we do end -->

  <!-- footer section start -->
  <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- mobile menu offcanvas -->
  <div class="offcanvas offcanvas-start" id="offcanvas-mobile">
    <div class="offcanvas-body">
      <div class="mobile-menu">
        <a href="<?php echo e(url('/')); ?>" class="logo py-3"><img src="assets/images/logo1.jpg" alt="logo"
            class="img-fluid"></a>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>

        <ul class="accordion accordion-flush mobile_dropdown" id="accordionFlushExample">
          <li class="accordion-item">
            <h2><a href="#">Home</a></h2>
          </li>
          <li class="accordion-item">
            <h2><a href="<?php echo e(url('about-us')); ?>">About Us</a></h2>
          </li>
          <li class="accordion-item">
            <h2><a href="<?php echo e(url('services')); ?>">Services</a></h2>
          </li>
          <li class="accordion-item">
            <h2><a href="<?php echo e(url('contact')); ?>">Contact Us</a></h2>
          </li>
        </ul>
      </div>
    </div>
  </div>

  <!-- Javascript Files -->
  <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/wow.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/fancybox.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/counterup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/progress-bar.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/smooth-scroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/nice-select.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/waypoints.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
</body>

</html><?php /**PATH /home1/wedlinei/public_html/lifeflowdonors.com/resources/views/about-us.blade.php ENDPATH**/ ?>