<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function (Blueprint $table) {

            $table->id();
             $table->foreignId("cust_id")->constrained("custregisters")->onDelete('cascade');
            $table->date('date');
            $table->time('time');
            $table->string('name');
            $table->integer('id_number');
            $table->string('qualification');
            $table->string('occupation');
            $table->string('work_place');
            $table->string('matching_name');
            $table->integer('m_id_number');
            $table->string('m_qualification');
            $table->string('m_occupation');
            $table->string('m_work_place');
            $table->string('matching_status');
            $table->dateTime('status_date_time');
            $table->date('meetup_date');
            $table->string('meetup_status');
            $table->string('marriage_status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('services');
    }
}