<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustregistersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('custregisters', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->time('call_time');
            $table->string('candidate_name');
            $table->string('Fathers_name');
            $table->string('mothers_name');
            $table->string('house_name');
            $table->string('mob_1');
            $table->string('mob_2');
            $table->string('gender');
            $table->date('date_of_birth');
            $table->integer('age');
            $table->string('religion');
            $table->string('cast');
            $table->string('candidate_watsupno');
            $table->string('candidate_email');
            $table->string('workplace');
            $table->string('qualification');
            $table->text('remark');
            $table->integer('task_status');
            $table->longText('follow_up')->nullable();
            $table->longText('refollow_up1')->nullable();
            $table->longText('refollow_up2')->nullable();
            $table->longText('refollow_up3')->nullable();
            $table->longText('refollow_up4')->nullable();
            $table->longText('refollow_up5')->nullable();
            $table->boolean('appointment')->default(true);
            $table->date('appoinment_date');
            $table->time('appoinment_time');
            $table->longText('appoinment_note')->nullable();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('custregisters');
    }
}