<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Package;

class Custregister extends Model
{
    use HasFactory;
    protected $table = 'custregisters';


    protected $casts = [
        'follow_up' =>'json',
         'matching_profile' =>'json',
    ];

protected $fillable = [
        'date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 
        'qualification','remark', 'task_status','follow_up', 'refollow_up1', 'refollow_up2', 'refollow_up3',
        'refollow_up4', 'refollow_up5','appointment','appointment_date','appoinment_time','appoinment_note',
        'b_date',
        'in_time',
        'expectations',
        'family_status',
        'house_details',
        'service_charge_details',
        'matching_profile_details',
        'payment_chance',
        'payment_details',
        'offer',
        'location',
        'landmark',
        'latitude',
        'longitude',
        'map',
        'out_time',
        'b_remarks',
         'profile_verification',
        'registration_d/t',
        'registration_status',
        'pending_reminder',
        'wm_id_no',
        'matching_profile',
        'date_time',
        'payment_reminder',
        'member_status',
        'plan_details',
        'invoice_no',
        'offer_details',
        'visits_status',
        'matching_profile_id',
        'matching_profile_name',
        'data_date_time',
        'data_assign',
        'data_remarks'
    ];

    protected $hidden = ['created_at','updated_at'];

public function Visits()
    {
         return $this->hasMany(Visits::class, 'vca_id');
    }

public function custregisters()
    {
        return $this->hasMany(Custregister::class);
    }
 
public function packages()
    {
        return $this->belongsTo(Package::class);
    }
    
public function getColumnNameAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }

 public function setColumnNameAttribute($value)
    {
        $this->attributes['follow_up'] = json_encode(array_values($value));

        $this->attributes['matching_profile'] = json_encode(array_values($value));

    }

   public function getDefaultStateAttribute()
{
    // Fetch the default state for the selected country
    $defaultState = State::where('country_code', $this->country)->first();

    // Return the default state ID if found
    return $defaultState ? $defaultState->id : null;
}

}