<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Package;
use App\Models\Users;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\WorkTracking;

class Custregister extends Model
{
    use HasFactory;
    protected $table = 'custregisters';

use SoftDeletes;

    protected $casts = [
        'follow_up' =>'json',
           'follow' =>'json',
          'matching_profile'=>'json',
         'p_matching_profile'=>'json',
        's_matching_profile'=>'json',
        'f_matching_profile'=>'json',
         'adm_followup'=>'json',
        'meet_me'=>'json'
    ];

protected $fillable = [
        'date', 'call_time','calling_reminder', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 
        'qualification','remark', 'task_status','follow_up', 'refollow_up1', 'refollow_up2', 'refollow_up3',
        'refollow_up4', 'refollow_up5','appointment','appointment_date','appoinment_time','appoinment_note',
        'b_date',
        'in_time','refferal_no',
        'expectations',
        'family_status',
        'house_details',
        'service_charge_details',
        'matching_profile_details',
        'payment_chance',
        'payment_details',
        'offer','follow',
        'location',
        'landmark',
        'latitude',
        'longitude',
        'map',
        'out_time',
        'b_remarks',
         'profile_verification',
        'registration_d/t',
        'registration_status',
        'pending_reminder',
        'wm_id_no',
        'matching_profile',
        'date_time',
        'payment_reminder',
        'member_status',
        'plan_details',
        'invoice_no',
        'offer_details',
        'visits_status',
        'matching_profile_id',
        'matching_profile_name',
        'data_date_time',
        'data_assign',
        'data_remarks','meet_me',
        'calling_status','adm_followup','dmatching','created_by'
        
    
    ];

    protected $hidden = ['created_at','updated_at','created_id','updated_id'];

  public function casts()
    {
         return $this->belongsTo(Cast::class, 'cast');
    }
    
public function Visits()
    {
         return $this->hasMany(Visits::class, 'vca_id');
    }

public function custregisters()
    {
        return $this->hasMany(Custregister::class);
    }
 
public function packages()
    {
        return $this->belongsTo(Package::class);
    }
    public function work_trackings()
    {
        // Assuming a one-to-many relationship, adjust if needed
        return $this->hasMany(WorkTracking::class, 'customer_id');
    }
    public function workTracking()
    {
        return $this->hasMany(WorkTracking::class, 'customer_id');
    }
    public function user()
    {
       
        return $this->belongsTo(Users::class,'created_id');
    }
    public function user1()
    {
        return $this->belongsTo(Users::class,'assign_to');
    }
      public function user2()
    {
        return $this->belongsTo(Users::class,'data_assign');
    }
     public function user3()
    {
        return $this->belongsTo(Users::class,'service_assign');
    }
    
    public function getFollowUpAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }

 public function setFollowUpAttribute($value)
    {
        $this->attributes['follow_up'] = json_encode(array_values($value));
    }
    public function getMatchingProfileAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }

 public function setMatchingProfileAttribute($value)
    {
        $this->attributes['matching_profile'] = json_encode(array_values($value));
    }
    public function getPMatchingProfileAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }

 public function setPMatchingProfileAttribute($value)
    {
        $this->attributes['p_matching_profile'] = json_encode(array_values($value));
    }
    public function getFMatchingProfileAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }

 public function setFMatchingProfileAttribute($value)
    {
        $this->attributes['f_matching_profile'] = json_encode(array_values($value));
    }
    public function getAdmFollowupAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }

 public function setAdmFollowupAttribute($value)
    {
        $this->attributes['adm_followup'] = json_encode(array_values($value));
    }
     public function getFollowAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }
    public function setFollowAttribute($value)
    {
        $this->attributes['follow'] = json_encode(array_values($value));
    }
      public function getMeetMeAttribute($value)
    {
        return array_values(json_decode($value, true) ?: []);
    }
    public function setMeetMeAttribute($value)
    {
        $this->attributes['meet_me'] = json_encode(array_values($value));
    }
// public function getColumnNameAttribute($value)
//     {
//         return array_values(json_decode($value, true) ?: []);
//     }

//  public function setColumnNameAttribute($value)
//     {
//         $this->attributes['follow_up'] = json_encode(array_values($value));

//         $this->attributes['matching_profile'] = json_encode(array_values($value));
//   $this->attributes['f_matching_profile'] = json_encode(array_values($value));
         
//             $this->attributes['p_matching_profile'] = json_encode(array_values($value));

//          $this->attributes['s_matching_profile'] = json_encode(array_values($value));
//          $this->attributes['adm_followup'] = json_encode(array_values($value));
//     }

   public function getDefaultStateAttribute()
{
    // Fetch the default state for the selected country
    $defaultState = State::where('country_code', $this->country)->first();

    // Return the default state ID if found
    return $defaultState ? $defaultState->id : null;
}
// public function setPaymentReminderAttribute($value)
// {
//     // Convert the input date in 'd-m-Y' format to 'Y-m-d' format before storing
//     $dateInput = \Carbon\Carbon::createFromFormat('d-m-Y', $value);
//     $this->attributes['payment_reminder'] = $dateInput->format('Y-m-d');
// }
//  public function setCallingReminderAttribute($value)
//     {
//         // Parse the input date and format it as 'Ymd'
//         $this->attributes['calling_reminder'] = \Carbon\Carbon::createFromFormat('d-m-Y', $value)->format(Y-m-d'');
//     }
public function getPaymentReminderAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d-m-Y');
    }

    public function setPaymentReminderAttribute($value)
    {
        $this->attributes['payment_reminder'] = \Carbon\Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
    }
 public function getCallingReminderAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d-m-Y');
    }

    public function setCallingReminderAttribute($value)
    {
        $this->attributes['calling_reminder'] = \Carbon\Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
    }
    public function getEngageDateAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d-m-Y');
    }

    public function setEngageDateAttribute($value)
    {
        $this->attributes['engage_date'] = \Carbon\Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
    }
      public function getMeetupDateAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d-m-Y');
    }

    public function setMeetupDateAttribute($value)
    {
        $this->attributes['meetup_date'] = \Carbon\Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
    }
     public function getMarriageDateAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d-m-Y');
    }

    public function setMarriageDateAttribute($value)
    {
        $this->attributes['marriage_date'] = \Carbon\Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
    }
}