<?php

namespace App\Http\Controllers;

use App\Models\Video;

use Illuminate\Http\Request;
use Validator;

class PublicVideoController extends Controller
{
    public function getVideo(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'exists:videos,id',
       
        ]);
        if ($validator->fails()) {
            return $validator->errors();
        }

        $id = $request->id;
        if($id){
            $vid =Video::find($id);
        }else{
            $vid = Video::get();
            if($vid->isEmpty()){
                return response()->json(["message" =>"Empty data"]);
            }
        }
        
        return response()->json(["message" =>"success","data"=>$vid]);
    }
}
