<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\SubCategory;

use Illuminate\Http\Request;
use Validator;

class PublicSubCategoryController extends Controller
{
    public function getSubCategory(Request $request){
        
        $validator = Validator::make($request->all(), [
            'cat_id' => 'exists:categories,id',
            'id' => 'required_without:cat_id|exists:sub_categories,id',
       
        ]);

        if ($validator->fails()) {
            return $validator->errors();
        }
        
        $cat_id = $request->cat_id;
        $id = $request->id;

        if($id){
            $sub_cat =SubCategory::find($id);
        }elseif($cat_id > 0){
            $sub_cat =SubCategory::where('cat_id',$cat_id)->get();
            if($sub_cat->isEmpty()){
                return response()->json(["message" =>"Empty data","data"=>$sub_cat]);    
            }
        }

        return response()->json(["message" =>"success","data"=>$sub_cat]);
    }
}
