<?php

namespace App\Http\Controllers;

use App\Models\Setting;

use Illuminate\Http\Request;
use Validator;

class PublicSettingsController extends Controller
{
    public function getSetting(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'exists:settings,id',
       
        ]);
        if ($validator->fails()) {
            return $validator->errors();
        }

        $id = $request->id;
        if($id){
            $set =Setting::find($id);
        }else{
            $set = Setting::get();
            if($set->isEmpty()){
                return response()->json(["message" =>"Empty data"]);
            }
        }
        
        return response()->json(["message" =>"success","data"=>$set]);
    }
}
