<?php

namespace App\Http\Controllers;

use App\Models\Product;

use Illuminate\Http\Request;
use Validator;

class PublicProductController extends Controller
{
    public function getProduct(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'exists:products,id',
       
        ]);
        if ($validator->fails()) {
            return $validator->errors();
        }

        $id = $request->id;
        if($id){
            $prod =Product::find($id);
        }else{
            $prod = Product::get();
            if($prod->isEmpty()){
                return response()->json(["message" =>"Empty data"]);
            }
        }
        
        return response()->json(["message" =>"success","data"=>$prod]);
    }
}
