<?php
 
namespace App\Console\Commands;
 
use Illuminate\Console\Command;
use App\Models\Custregister;
use App\Models\Notifications;
use Carbon\Carbon;
 
class ShowNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'show:notifications';
 
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';
 
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }
 
    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $dateString = now()->toDateString();
        $records = Custregister::where('payment_reminder', $dateString)->get();
        $caling = Custregister::where('calling_reminder', $dateString)->get();
         $Engage = Custregister::where('engage_date', $dateString)->get();
          $Meetup = Custregister::where('meetup_date', $dateString)->get();
         $mariage = Custregister::where('marriage_date', $dateString)->get();
 
        foreach ($records as $record) {
            Notifications::create([
                'customer_id' => $record->id,
                'note' => $record->payment_note,
                'date' => Carbon::parse($record->payment_reminder)->toDateString(), // Format the date correctly
                'remainder' => "Payment Reminder",
                'user_id' => $record->created_by,
                'cust_name' => $record->candidate_name,
                'read' => 0,
            ]);
        }
 
        foreach ($caling as $call) {
            Notifications::create([
                'customer_id' => $call->id,
                'note' => $call->calling_status,
                'date' => Carbon::parse($call->calling_reminder)->toDateString(), // Format the date correctly
                'read' => 0,
                'user_id' => $call->created_id,
                'cust_name' => $call->candidate_name,
                'remainder' => "Calling Reminder",
            ]);
        }
        foreach ($Engage as $Engages) {
            Notifications::create([
                'customer_id' => $Engages->id,
                'note' => $Engages->engage_status,
                'date' => Carbon::parse($Engages->engage_date)->toDateString(), // Format the date correctly
                'read' => 0,
                'user_id' => $Engages->created_by,
                'cust_name' => $Engages->candidate_name,
                'remainder' => "Engagement Reminder",
            ]);
        }
            foreach ($Meetup as $Meet) {
            Notifications::create([
                'customer_id' => $Meet->id,
                'note' => $Meet->meetup_status,
                'date' => Carbon::parse($Meet->meetup_date)->toDateString(), // Format the date correctly
                'read' => 0,
                'user_id' => $Meet->created_by,
                'cust_name' => $Meet->candidate_name,
                'remainder' => "Meetup Reminder",
            ]);
        }
         foreach ($mariage as $mariages) {
            Notifications::create([
                'customer_id' => $mariages->id,
                'note' => $mariages->marriage_status,
                'date' => Carbon::parse($mariages->marriage_date)->toDateString(), // Format the date correctly
                'read' => 0,
                'user_id' => $mariages->created_by,
                'cust_name' => $mariages->candidate_name,
                'remainder' => "Mariage Reminder",
            ]);
        }
 
        $this->info('Updated pending_remainder and created notifications.');
 
        return 0;
    }
}