<?php

namespace App\Admin\Controllers;

use App\Models\Setting;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;

class SettingController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Setting';
    

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Setting());

        $grid->disableFilter();
        $grid->disableCreateButton();
        
        $grid->actions(function ($actions) {
            $actions->disableDelete();
            
        });
        $grid->column('title', __('Title'));
        $grid->column('value', __('Value'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Setting::findOrFail($id));
        $show->panel()->tools(function ($tools) {
        
        $tools->disableDelete();
    });

        $show->field('title', __('Title'))->setWidth(4, 2);
        $show->field('value', __('Value'))->setWidth(4, 2);

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Setting());


        $form->tools(function ($tools) {

            // Disable `Delete` btn.
            $tools->disableDelete();
      
        });
       
        $form->text('title', __('Title'))->setWidth(4, 2)->rules('required|string')->disable();
        $form->text('value', __('Value'))->setWidth(4, 2)->rules('required|string');

        return $form;
    }
}
