<?php

namespace App\Admin\Controllers;

use App\Models\Package;
use App\Models\Constant;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;

class PackageController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Package';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Package());

        $grid->column('name', __('Name'));
        $grid->column('price', __('Price'));
        $grid->column('duration', __('Duration'));
        $grid->column('limit', __('Limit'));
       
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Package::findOrFail($id));

        $show->field('name', __('Name'))->setWidth(4, 2);
        $show->field('price', __('Price'))->setWidth(4, 2);
        $show->field('duration', __('Duration'))->setWidth(4, 2);
        $show->field('limit', __('Limit'))->setWidth(4, 2);
        
        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Package());

        $form->text('name', __('Name'))->setWidth(4, 2)->rules('required|min:2|max:50');
        $form->currency('price', __('Price'))->rules('required|numeric');
        $form->text('duration', __('Duration'))->setWidth(4, 2)->rules('required|numeric');
        $form->text('limit', __('Limit'))->setWidth(4, 2)->rules('required|numeric');
       // $form->select('user_type', __('User type'))->setWidth(4, 2)->options(Constant::USER_TYPE);
      // $form->hidden('created_user_id')->default(Auth()->user()->id);
      //  $form->hidden('updated_user_id')->default(Auth()->user()->id);

        return $form;
    }
}
