<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Carbon\Carbon;

class ServiceExecutiveController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Service';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Service());
        $grid->column('id', __('ID'));
        $grid->column('date', __('Date'));
        $grid->column('time', __('Time'));
        $grid->column('name', __('Name'));
        $grid->column('id_number', __('ID Number'));
        $grid->column('qualification', __('Qualification'));
        $grid->column('occupation', __('Occupation'));
        $grid->column('work_place', __('Work Place'));
        $grid->column('matching_name', __('Matching Name'));
        $grid->column('m_id_number', __('M ID Number'));
        $grid->column('m_qualification', __('M Qualification'));
        $grid->column('m_occupation', __('M Occupation'));
        $grid->column('m_work_place', __('M Work Place'));
        $grid->column('matching_status', __('Matching Status'));
        $grid->column('status_date_time', __('Status Date & Time'));
        $grid->column('meetup_date', __('Meetup Date'));
        $grid->column('meetup_status', __('Meetup Status'));
        $grid->column('marriage_status', __('Marriage Status'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Service::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('time', __('Time'));
        $show->field('name', __('Name'));
        $show->field('id_number', __('ID Number'));
        $show->field('qualification', __('Qualification'));
        $show->field('occupation', __('Occupation'));
        $show->field('work_place', __('Work Place'));
        $show->field('matching_nam', __('Matching Name'));
        $show->field('m_id_number', __('M ID Number'));
        $show->field('m_qualification', __('M Qualification'));
        $show->field('m_occupation', __('M Occupation'));
        $show->field('m_work_place', __('M Work Place'));
        $show->field('matching_statuss', __('Matching Status'));
        $show->field('status_date_time', __('Status Date & Time'));
        $show->field('meetup_date', __('Meetup Date'));
        $show->field('meetup_status', __('Meetup Status'));
        $show->field('marriage_status', __('Marriage Status'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Service());

        $form->date('date', __('Date'))->default(date('Y-m-d'));
        $form->time('time', __('Time'))->default(date('H:m'));
        $form->text('name', __('Name'));
        $form->number('id_number', __('ID Number'));
        $form->text('qualification', __('Qualification'));
        $form->text('occupation', __('Occupation'));
        $form->text('work_place', __('Work Place'));
        $form->text('matching_name', __('Matching Name'));
        $form->number('m_id_number', __('M ID Number'));
        $form->text('m_qualification', __('M Qualification'));
        $form->text('m_occupation', __('M Occupation'));
        $form->text('m_work_place', __('M Work Place'));
        $form->text('matching_status', __('Matching Status'));
        $form->datetime('status_date_time', __('Status Date & Time'))->value(date('Y-m-d H:m'));
        $form->date('meetup_date', __('Meetup Date'));
        $form->text('meetup_status', __('Meetup Status'));
        $form->text('marriage_status', __('Marriage Status'));
       
        return $form;
    }
}