<?php

namespace App\Admin\Controllers;

use App\Models\Destinationcategory;
use App\Models\Destination;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class DestinationsController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Destinations';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       $grid = new Grid(new Destination());
         $grid->column('id',__('ID'));
       $grid->column('destination_name',__('Destination Name'));
       $grid->column('destinationcategories.categoryname',__('Category'))->sortable();
        $grid->column('image',__('Image'))->image('',60,60);
        $grid->column('description',__('Description'));    
       $grid->column('active',__('Active'))->display(function ($active) {
           if($active ===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});
       

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     *@click and view projects
     */
    protected function detail($id) 
    {
        
        $show = new Show(Destination::findOrFail($id));
         $show->field('id',__('ID'));
          $show->field('destination_name',__('Destination Name'))->setWidth(4, 2);
      $show->field('destinationcategories.categoryname',__('Select Category'))->setWidth(4, 2);
       $show->field('image',__('Image'))->image('',60,60);
        $show->field('description',__('Description'));
       $show->field('active',__('Active'))->as(function ($active) {
           if($active===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});
       
        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */


    protected function form() //form add/edit
    {
        $form = new Form(new Destination());

         $form->text('destination_name',__('Destination Name'))->setWidth(4, 2);
         $form->select('dest_id',__('Select Category'))->options(Destinationcategory::all()->pluck('categoryname', 'id'))->setWidth(4, 2)->rules('required');
       
        $form->cropper('image',__('Image'))->cRatio('330','260')->removable()->move('places/sub_destination');
         $form->summernote('description',__('Description'));
         $form->text('order',__('Order'))->setWidth(4, 2)->rules('required|numeric');
        //$form->multipleFile('thumbnail',__('Thumbnail ,Image size  must should be (width-214,height-180)'))->removable()->rules('mimes:jpeg,png,jpg')->move('projectdetails/thumbnail');
        $form->switch('active', __('Active'))->states(Constant::STATUS)->default(1);
        return $form;
    }
}
