<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Dataentry;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class DataentryController extends AdminController
{
    /**
     * Title for the current resource.
     *
     * @var string
     */
    protected $title = 'Data Entry';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Dataentry());
        $grid->column('id', __('ID'));
        $grid->column('date', __('Date'));
        $grid->column('time', __('Time'));
        $grid->column('profile_verification',__('Profile Verification'))->display(function ($ProfileVerification) {
            if($ProfileVerification ===Constant::STATUS_NO){
                return "No";
            }else{
                return "Yes";
            }});
        $grid->column('registration_d/t', __('Registration Date/Time'));
        $grid->column('registration_status', __('Registration status'));
        $grid->column('pending_reminder', __('Pending Reminder'));
        $grid->column('wm_id_no', __('WM ID NO'));
        $grid->column('matching_profile', __('Matching Profile'));
        $grid->column('date_time', __('Date & Time'));
        $grid->column('matching_profile_status', __('Matching Profile Status'));
        $grid->column('payment_chance', __('Payment Chance'));
        $grid->column('payment_reminder', __('Payment Reminder'));
        $grid->column('member_status', __('Member Status'));
        $grid->column('plan_details', __('Plan details'));
        $grid->column('invoice_no', __('Invoice No'));
        $grid->column('offer_details', __('Offer Details'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Dataentry::findOrFail($id));
        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('time', __('Time'));
        $show->field('profile_verification',__('Profile Verification'))->display(function ($ProfileVerification) {
            if($ProfileVerification ===Constant::STATUS_NO){
                return "No";
            }else{
                return "Yes";
            }});
        $show->field('registration_d/t', __('Registration date/Time'));
        $show->field('registration_status', __('Registration status'));
        $show->field('pending_reminder', __('Pending Reminder'));
        $show->field('wm_id_no', __('WM ID NO'));
        $show->field('matching_profile', __('Matching Profile'));
        $show->field('date_time', __('Date & Time'));
        $show->field('matching_profile_status', __('Matching Profile Status'));
        $show->field('payment_chance', __('Payment Chance'));
        $show->field('payment_reminder', __('Payment Reminder'));
        $show->field('member_status', __('Member Status'));
        $show->field('plan_details', __('Plan details'));
        $show->field('invoice_no', __('Invoice No'));
        $show->field('offer_details', __('Offer Details'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Dataentry());

        $form->date('date', __('Date'))->default(date('Y-m-d'));
        $form->time('time', __('Time'))->default(date('H:m'));
        $form->switch('profile_verification', __('Profile Verification'))->states(Constant::STATUS);
        $form->datetime('registration_d/t', __('Registration Date/Time'))->value(date('Y-m-d H:m'));
        $form->select('registration_status', __('Registration status'));
        $form->text('pending_reminder', __('Pending Reminder'));
        $form->number('wm_id_no', __('WM ID NO'));
        $form->text('matching_profile', __('Matching Profile'));
        $form->datetime('date_time', __('Date & Time'))->value(date('Y-m-d H:m'));
        $form->select('matching_profile_status', __('Matching Profile Status'));
        $form->select('payment_chance', __('Payment Chance'));
        $form->text('payment_reminder', __('Payment Reminder'));
        $form->select('member_status', __('Member Status'));
        $form->text('plan_details', __('Plan details'));
        $form->text('invoice_no', __('Invoice No'));
        $form->text('offer_details', __('Offer Details'));

        return $form;
    }
}