<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Custregister;
use App\Models\Visits;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Carbon\Carbon;

class CustRegisterController extends AdminController
{
  /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Customer';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Custregister());
        $grid->model()->orderBy('id', 'desc');

       //$grid->column('id', __('ID'));

        $grid->column('id', __('SL.NO'))->display(function ($id) {
        // Calculate the total number of records in the table
        $totalRecords = Custregister::count();
        // Calculate the displayed ID by subtracting the current ID from the total records and adding 1
        $displayedId = $totalRecords - $id + 1;
        return $displayedId;
   });
        $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
    });
        $grid->column('call_time', __('Call Time'));
        $grid->column('candidate_name', __('Candidate Name'));
        $grid->column('fathers_name', __("Father's Name"));
        $grid->column('mothers_name', __("Mother's Name"));
        $grid->column('house_name', __('Address'));
        
        $grid->column('mob_1', __('Mobile 1'));
        $grid->column('mob_2', __('Mobile 2'));
        $grid->column('gender', __('Gender'));
        $grid->column('age', __('Age'));
        $grid->column('religion', __('Religion'));
        $grid->column('cast', __('Cast'));
        $grid->column('candidate_watsupno', __('Candidate WhatsApp Number'));
        $grid->column('candidate_email', __('Candidate Email'));
        $grid->column('workplace', __('Workplace'));
        $grid->column('qualification', __('Qualification'));
        $grid->column('remark', __('Remark'));
        $grid->column('task_status', __('task_status'));
        $grid->column('follow_up', __('Follow Up'));
        $grid->column('refollow_up1', __('Follow Up 1'));
        $grid->column('refollow_up2', __('Follow Up 2'));
        $grid->column('refollow_up3', __('Follow Up 3'));
        $grid->column('refollow_up4', __('Follow Up 4'));
        $grid->column('refollow_up5', __('Follow Up 5'));
        $grid->column('appointment', __('Appointment'))->display(function ($appointment) {
            if($appointment ===Constant::STATUS_NO){
                return "No";
            }else{
                return "Yes";
            }});
        $grid->column('appoinment_date', __('Appointment Date'));
        $grid->column('appoinment_time', __('Appoinment_Time'));
        $grid->column('appoinment_note', __('Appoinment_Note'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {   
        $href_app= env('APP_URL')."admin/appoinment";

        $show = new Show(Custregister::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('call_time', __('Call Time'));
        $show->field('candidate_name', __('Candidate Name'));
        $show->field('fathers_name', __("Father's Name"));
        $show->field('mothers_name', __("Mother's Name"));
        $show->field('house_name', __('Address'));
        $show->field('mob_1', __('Mobile 1'));
        $show->field('mob_2', __('Mobile 2'));
        $show->field('gender', __('Gender'));
        $show->field('date_of_birth', __('Date of Birth'))->as(function ($dateOfBirth) {
            return $dateOfBirth->format('Y-m-d') . ' (Age: ' . Carbon::parse($dateOfBirth)->age . ')';});
        $show->field('religion', __('Religion'));
        $show->field('cast', __('Cast'));
        $show->field('candidate_watsupno', __('Candidate WhatsApp Number'));
        $show->field('candidate_email', __('Candidate Email'));
        $show->field('workplace', __('Workplace'));
        $show->field('qualification', __('Qualification'));
        $show->field('remark', __('Remark'));
        $show->field('task_status', __('task_status'));
        $show->field('follow_up', __('Follow Up'));
        $show->field('refollow_up1', __('Follow Up 1'));
        $show->field('refollow_up2', __('Follow Up 2'));
        $show->field('refollow_up3', __('Follow Up 3'));
        $show->field('refollow_up4', __('Follow Up 4'));
        $show->field('refollow_up5', __('Follow Up 5'));
        $show->field('appointment', __('Appointment'))->display(function ($appointment) {
            if($appointment ===Constant::STATUS_NO){
                return "No";
            }else{
                return "Yes";
            }});;
        $show->field('appoinment_date', __('Appoinment_Date'));
        $show->field('appoinment_time', __('Appoinment_Time'));
        $show->field('appoinment_note', __('Appoinment_Note'));
       
        return $show;
    }

    protected function form()
    {
        $form = new Form(new Custregister());

        $form->date('date', __('Date'))->default(date('Y-m-d'));
        $form->time('call_time', __('Calling Time'))->default(date('H:m'));
        $form->text('candidate_name', __('Candidate Name'));
        $form->text("fathers_name", __("Father's Name"));
        $form->text("mothers_name", __("Mother's Name"));
        $form->textarea('house_name', __('Address'))->rows(5)->style('width', '300px; height: 150px;');
        $countriesList = $this->getAllCountryNamesFromGoogle();
         $form->select('country', __('Country'))->options($countriesList);
        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->radioCard('gender', __('Gender'))->options(['Male' => 'Male', 'Female' => 'Female'])->stacked();
        $form->select('datasource', __('Data Source'))->options(['1'=> 'Advertisement','2'=> 'Refferal','3'=> 'Direct','4'=> 'Facebook','5'=>'Instagram','6'=>'Youtube'])
        ->when(2, function (Form $form) {

       
       $form->text('refferal_name', __('Refferal Name'));
        });
        $form->date('date_of_birth', __('Date of Birth'))->default(date('Y-m-d'))->setWidth(4, 2);
        $form->number('age', __('Age'));
        $form->text('religion', __('Religion'))->setWidth(4, 2);
        $form->text('cast', __('Cast'));
        $form->text('candidate_watsupno', __('Candidate WhatsApp Number'));
        $form->email('candidate_email', __('Candidate Email'));
        $form->text('workplace', __('Workplace'));
        $form->text('qualification', __('Qualification'));
        $form->text('remark', __('Remark'));
        $form->hidden('task_status', __('task_status'));
        
        $form->hasMany('Custregister', __('Follow Up'), function (Form\NestedForm $form) {
            $form->text('refollow_up1', __('Follow Up'));
           
        });
   // $form->hasMany('Custregister', __("Follow Up "), function (Form\NestedForm $form) {
           //  for ($i = 1; $i <= 5; $i++) {
           //     $form->text("refollow_up_$i", __("Follow Up $i"));
             
           //  }
       // });
     
        $form->switch('appointment', __('Appointment'))->states(Constant::STATUS)->default(1);
        $form->date('appoinment_date', __('Appointment Date'))->default(date('Y-m-d'));
        $form->time('appoinment_time', __('Appointment Time'))->default(date('H:m')) ;
        $form->textarea('appoinment_note', __('Appointment Note'))->rows(5)->style('width', '600px') ->style('height', '150px') ;
        $form->divider();
        $form->saved(function (Form $form) {
          
            if ($form->model()->appointment == 1)
            {
                $form->model()->task_status;
            }
            // Check if the condition is met (appointment = 1 and task_status = 0)
            if ($form->model()->appointment == 1 && $form->model()->task_status == 0) {
                // Get the ID of the current customer
                $customerId = $form->model()->id;

                // Redirect to the VisitassignController's create form with the customer ID as a parameter
            $visit = Visits::latest('id')->first();
            $form->saving(function (Form $form) use ($visit) {
                    // Set the vca_id field with the corresponding id from the latest Custregister record

                    $form->model()->vca_id = $visit->id;
                    $form->model()->date = $visit->date;
                    $form->model()->candidate_name = $visit->candidate_name;
                    $form->model()->appointment_date = $visit->appointment_date;
                    $form->model()->appointment_time=$visit->appointment_time;
                    $form->model()->appointment_note = $visit->appointment_note;
                    $form->model()->house_name = $visit->house_name;
                });
            }
       });
        return $form;
    }
    
}
