<?php

namespace App\Admin\Controllers;

use App\Models\Career;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Illuminate\Http\Request;
use DB;

class CareerController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Careers';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Career());
        $grid->column('id',__('ID'));
        $grid->column('jobtitle',__('Job-Title'));
        $grid->column('description',__('Description'));
        $grid->column('Active',__('Active'))->display(function ($active) {
           if($active ===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Career::findOrFail($id));
        
        $show->field('id',__('ID'))->setWidth(4, 2);
        $show->field('jobtitle',__('Job-Title'))->setWidth(4, 2);
        $show->field('description',__('Description'));
        $show->field('Active',__('Active'))->setWidth(2, 2);

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Career());
        
       
        $form->text('jobtitle',__('Job-Title'))->setWidth(4, 2)->rules('required|min:2');
        $form->textarea('description',__('Description'));
        $form->switch('Active',__('Active'))->states(Constant::STATUS)->default(1);
       
        return $form;
    }

}
