<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Users;
use App\Models\Custregister;
use Encore\Admin\Facades\Admin;
use Carbon\Carbon;
use App\Models\WorkTracking;
use App\Models\Religion;
use App\Models\Cast;
use Encore\Admin\Layout\Row;

class ServiceExecutiveController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Service';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       // $grid = new Grid(new Service());
       

        $date=intval(request('d')); 
         $grid = new Grid(new Custregister());
         

         $loginId = Admin::user()->id;  

       if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->whereNotNull('service_assign')->whereIn('member_status', [1, 2]);
}
    else{
   
    $grid->model()->where(function ($query) use ($loginId) {
        $query->where('service_assign', $loginId)
              ->where('member_status', 1);
    })->orWhere(function ($query) use ($loginId) {
        $query->where('service_assign', $loginId)
              ->where('member_status', 2);
    });
    }
    if ($date == 1) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
            
    $grid->model()->whereNotNull('service_assign')->whereNull('service_status');
}
    else{
        $grid->model()->where(function ($query) use ($loginId) {
            $query->where('service_assign', $loginId)
                  ->where('member_status', 1)->whereNull('service_status');
        })->orWhere(function ($query) use ($loginId) {
            $query->where('service_assign', $loginId)
                  ->where('member_status', 2)->whereNull('service_status');
        });
    }     

   }
   if ($date == 6){
    if (Admin::user()->inRoles(['Administrator', 'Manager'])){
$grid->model()->where('member_status',0);
}
else{

    $grid->model()->where('service_assign', $loginId)->where('member_status',0);
}
}
   
if ($date == 7){
    if (Admin::user()->inRoles(['Administrator', 'Manager'])){
$grid->model()->where('member_status',1);
}
else{

    $grid->model()->where('service_assign', $loginId)->where('member_status',1);
}
}
  
if ($date == 8){
    if (Admin::user()->inRoles(['Administrator', 'Manager'])){
$grid->model()->where('member_status',2);
}
else{

    $grid->model()->where('service_assign', $loginId)->where('member_status',2);
}
}
     
       $grid->model()->orderBy('id', 'desc');
        $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
      $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        });
  $grid->column('wm_id_no', __('WM ID NO'));
   
      $grid->column('candidate_name', __('Candidate Name'));
      $grid->column('fathers_name', __("Father's Name"));
     // $grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'))->hide();
      $grid->column('place', __('Place/Area'));
      $grid->column('mob_1', __('Mobile 1'));
      $grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'))->hide();
      $grid->column('religion', __('Religion'));
      $grid->column('cast', __('Cast'))->hide();
     
       
          $grid->disableCreateButton();
 $grid->column('Shared To')->display(function () {
        $id = $this->id;
      
      
    return "<a href='services/$id?'target='_blank' rel='nooper'>Shared To</a>";
    });
      $grid->actions(function ($actions) {
          
             $actions->disableView();// Disable the view action
        });
         $grid->filter(function ($filter) {
        $filter->disableIdFilter();
           $filter->in('member_status','Payment')->multipleSelect([
    '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid',
            '3' => 'Not Interest'
]);
  
         $filter->like('wm_id_no', __('WM ID NO'));
   
    });
     $grid->quickSearch('date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 'plan_details',
        'qualification','occupation','country','state','place','calling_status','wm_id_no','marital_status');
      if (Admin::user()->inRoles(['Administrator', 'Manager'])){
   // $grid->model()->whereNotNull('created_id');
    $grid->column('user3.name', __('Staff Name'));
}
       
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
     protected function detail($id)
    {
        $show = new Show(Custregister::findOrFail($id));
    
    $show->field('candidate_name');
        // Get the current candidate's wm_id_no
        $currentCandidate = \App\Models\Custregister::select('id', 'wm_id_no', 'candidate_name')
            ->find($id);
        $currentWmIdNo = $currentCandidate->wm_id_no;
    
        // Fetch all candidates
        $allCandidates = \App\Models\Custregister::select('id', 'wm_id_no', 'candidate_name', 'matching_profile', 'f_matching_profile', 'p_matching_profile')->get();
    
        $savedByCandidates = [];
    
        foreach ($allCandidates as $candidate) {
            $wmId = $candidate->wm_id_no;
    
            // Decode the `matching_profile`
            $matchingProfile = is_string($candidate->matching_profile) ? json_decode($candidate->matching_profile, true) : $candidate->matching_profile;
            if (is_array($matchingProfile)) {
                foreach ($matchingProfile as $profile) {
                    if (
                        isset($profile['matching_profile_id']) &&
                        strtolower($profile['matching_profile_id']) === strtolower($currentWmIdNo)
                    ) {
                        $savedByCandidates[] = [
                            'candidate_name' => $candidate->candidate_name,
                            'wm_id_no' => $wmId,
                            'shared_date' => $profile['data_date_time'] ?? 'N/A', // Add shared date
                        ];
                    }
                }
            }
    
            // Decode the `f_matching_profile`
            $fMatchingProfile = is_string($candidate->f_matching_profile) ? json_decode($candidate->f_matching_profile, true) : $candidate->f_matching_profile;
            if (is_array($fMatchingProfile)) {
                foreach ($fMatchingProfile as $profile) {
                    if (
                        isset($profile['matching_profile_id']) &&
                        strtolower($profile['matching_profile_id']) === strtolower($currentWmIdNo)
                    ) {
                        $savedByCandidates[] = [
                            'candidate_name' => $candidate->candidate_name,
                            'wm_id_no' => $wmId,
                            'shared_date' => $profile['data_date_time'] ?? 'N/A', // Add shared date
                        ];
                    }
                }
            }
    
            // Decode the `p_matching_profile`
            $pMatchingProfile = is_string($candidate->p_matching_profile) ? json_decode($candidate->p_matching_profile, true) : $candidate->p_matching_profile;
            if (is_array($pMatchingProfile)) {
                foreach ($pMatchingProfile as $profile) {
                    if (
                        isset($profile['m_id_number']) &&
                        strtolower($profile['m_id_number']) === strtolower($currentWmIdNo)
                    ) {
                        $savedByCandidates[] = [
                            'candidate_name' => $candidate->candidate_name,
                            'wm_id_no' => $wmId,
                            'shared_date' => $profile['date'] ?? 'N/A', // Add shared date
                        ];
                    }
                }
            }
        }
    
        // Display the result in a table format
        $show->field('saved_by_candidates', __('Shared To'))->unescape()->as(function () use ($savedByCandidates) {
            $table = '<table border="1" style="border-collapse: collapse; width: 100%;">';
            $table .= '<thead><tr><th>Candidate Name</th><th>WM ID No</th><th>Shared Date</th></tr></thead>';
            $table .= '<tbody>';
    
            if (!empty($savedByCandidates)) {
                foreach ($savedByCandidates as $candidate) {
                    $table .= '<tr>';
                    $table .= '<td>' . $candidate['candidate_name'] . '</td>';
                    $table .= '<td>' . $candidate['wm_id_no'] . '</td>';
                    $table .= '<td>' . $candidate['shared_date'] . '</td>'; // Display shared date
                    $table .= '</tr>';
                }
            } else {
                $table .= '<tr><td colspan="3" style="text-align: center;">No Match Found</td></tr>';
            }
    
            $table .= '</tbody></table>';
            return $table;
        });
    
        return $show;
    }
    
    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
       /// $form = new Form(new Service());
        $user_id = intval(request('user_id'));
       $form = new Form(new Custregister()); // Use the Business model

     
  // $form->hidden('cust_id')->value($user_id); // Populate the hidden input field

    $form->radioCard('custmer', __('Customer'))->options(['1'=> 'Show Details','0'=>'Hide Deatils'])
        ->when(1, function (Form $form) use ($user_id) {
        $form->text('candidate_name', __('Candidate Name'))->readonly();//->value($custregisterId->candidate_name);
        $form->text("fathers_name", __("Father's Name"))->readonly();//->value($custregisterId->fathers_name);
        $form->text("mothers_name", __("Mother's Name"))->readonly();//->value($custregisterId->mothers_name);
        $form->textarea('house_name', __('Address '))->readonly();//->rows(5)->style('width', '300px; height: 150px;')->value($custregisterId->house_name);
        $form->mobile('mob_1', __('First Mobile Number'))->readonly();//->options(['mask' => '999 999 9999'])->setWidth(4, 2)->value($custregisterId->mob_1);
        $form->mobile('mob_2', __('Second Mobile Number'))->readonly();//->options(['mask' => '999 999 9999'])->setWidth(4, 2)->value($custregisterId->mob_2);
        $form->date('date_of_birth', __('Date of Birth')) ->default(today()->format('d-m-Y'))
         ->format('DD-MM-YYYY')->readonly();//->default(date('Y-m-d'))->setWidth(4, 2)->value($custregisterId->date_of_birth);
        $form->text('age', __('Age'))->setWidth(4, 2)->readonly();//->value($custregisterId->age);
       $form->text('religion', __('Religion'))->setWidth(4, 2)->readonly();
    //   $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','cast_name'));
     $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','id'))->setWidth(4, 2)->readonly();
     $form->email('candidate_email', __('Candidate Email'))->readonly()->setWidth(4, 2);
        $form->text('workplace', __('Workplace'))->readonly()->setWidth(4, 2);
        $form->text('qualification', __('Qualification'))->readonly()->setWidth(4, 2);
        $form->text('remark', __('Remark'))->setWidth(4, 2)->readonly();
     
         $form->text('marital_status', __('Marital Status'))->readonly();
           $form->text('family_status', __('Family Status'))->readonly();
         $form->text('complexion', __('Complexion'))->readonly();
        $form->textarea('service_charge_details', __('Service Charge Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2)->readonly();
        $form->text('invoice_no', __('Invoice No'))->readonly();
        $form->text('invoice_date', __('Invoice Date'))->readonly();
        $form->text('offer_details', __('Offer Details'))->readonly();
       
         $form->text('payment_note', __('Payment Note'))->readonly();
             
             
        });
       
        
         $form->radio('member_status', __('Member Status'))->options([
            '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid',
            '3' => 'Not Interest',
            '4' => 'expired'
            ])->when (1 , function(form $form){

      

      $form->table('f_matching_profile','Data Entry Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required')->readonly();
                $table->text('matching_profile_name','Matching Profile Name')->rules('required')->readonly();
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a')->readonly();
                 $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
            })->readonly();


         })->when (0, function(form $form){

         
            $form->table('matching_profile','Data Entry Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required')->readonly();
                $table->text('matching_profile_name','Matching Profile Name')->rules('required')->readonly();
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a')->readonly();
                 $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
            })->readonly();
         });
         
         
           $form->text('s_remark', __('Service Note'));
         
       $form->table('p_matching_profile','Service Matching Profiles', function ($table) {
        $table->datetime('date', __('Date'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
        //$table->time('time', __('Time'))->default(date('H:m'));
        $table->text('name', __('Name'));
       // $table->text('id_number', __('ID Number'));
       // $table->text('qualification', __('Qualification'));
        $table->text('occupation', __('Occupation'));
       // $table->text('work_place', __('Work Place'));
       // $table->text('matching_name', __('Matching Name'));
        $table->text('m_id_number', __('M ID Number'));
       // $table->text('m_qualification', __('M Qualification'));
       // $table->text('m_occupation', __('M Occupation'));
       
        $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
         $table->textarea('m_work_place', __('Note'));
       });
        $form->datetime('status_date_time', __('Status Date & Time'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
      $form->table('meet_me','Meetup Me', function ($table) {
        $table->datetime('date', __(' MeetUp Date'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
     $table->text('m_id_number', __('W ID Number'));
        $table->text('name', __('Name'));
        $table->text('status', __('Status'));
       
       });
        $form->date('meetup_date', __('Meetup Date'))->format('DD-MM-YYYY');
            $form->text('meetup_status', __('Meetup Status'));
       $form->text('can_id', __('Meetup Candidate ID'));
       $form->text('can_name', __('Meetup Candidate Name'));
        $form->date('engage_date', __('Engagement Date'))->format('DD-MM-YYYY');
          $form->text('engage_status', __('Engagement Status'));
        $form->date('marriage_date', __('Marriage Date'))->format('DD-MM-YYYY');
          $form->text('marriage_status', __('Marriage Status'));
           $form->hidden('service_status')->default(intval(3));

         $form->saving(function (Form $form) {
        $dateOfBirth = $form->input('date_of_birth');
            if ($dateOfBirth) {
                $dateOfBirth = Carbon::parse($dateOfBirth);
                $age = Carbon::now()->diffInYears($dateOfBirth);
                $form->input('age', $age);
            }
             //$custregister = Custregister::where('appointment', 1)
           // ->where('task_status', 0)->all();
            $custregister = $form->model()->id;
            $role = Admin::user()->roles;
            
              $loginId = Admin::user()->id;
              $form->model()->created_by = $loginId;

        if ($custregister && $role) {
    // Assuming that $roles is a collection of roles
    $roleNames = $role->pluck('name')->implode(', ');

            $tracks = new WorkTracking();
            $tracks->customer_id = $custregister;
            $tracks->user_id =  $loginId;
            $tracks->role_name =  $roleNames;
          
            // Save the Visits record
            $tracks->save();
        }
 });
 $form->tools(function (Form\Tools $tools) {

                 
    // Disable `Veiw` btn.
    $tools->disableView();

  
});
        return $form;

    }
}