<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\Users;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Custregister;
use Carbon\Carbon;

class ServiceExecutiveAssignController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Service Assign';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       // $grid = new Grid(new Service());

        
        $grid = new Grid(new Custregister());

      $grid->model()->where('data_status', 2)   ->whereIn('member_status', [1, 2]);
     
       
         $grid->model()->orderBy('id', 'desc');
        $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
      $grid->column('candidate_name', __('Candidate Name'));
      $grid->column('fathers_name', __("Father's Name"));
     // $grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
           $grid->column('place', __('Place/Area'));
      $grid->column('mob_1', __('Mobile 1'));
      $grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
      $grid->column('cast', __('Cast'))->hide();
         $grid->column('marital_status', __('Marital Status'))->hide();
      $grid->column('service_assign', __('Assign To'))->editable('select',(Users::pluck('name','id')));
      $grid->column('service_remarks', __('Remarks'))->editable('textarea');

      $grid->disableCreateButton();

      $grid->actions(function ($actions) {
            $actions->disableEdit();
             $actions->disableView();// Disable the view action
        });
              $grid->quickSearch('date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 'plan_details',
        'qualification','occupation','country','state','place','calling_status','wm_id_no','marital_status');

        $grid->disableFilter();


        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Service::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('time', __('Time'));
        $show->field('name', __('Name'));
        $show->field('id_number', __('ID Number'));
        $show->field('qualification', __('Qualification'));
        $show->field('occupation', __('Occupation'));
        $show->field('work_place', __('Work Place'));
        $show->field('matching_nam', __('Matching Name'));
        $show->field('m_id_number', __('M ID Number'));
        $show->field('m_qualification', __('M Qualification'));
        $show->field('m_occupation', __('M Occupation'));
        $show->field('m_work_place', __('M Work Place'));
        $show->field('matching_statuss', __('Matching Status'));
        $show->field('status_date_time', __('Status Date & Time'));
        $show->field('meetup_date', __('Meetup Date'));
        $show->field('meetup_status', __('Meetup Status'));
        $show->field('marriage_status', __('Marriage Status'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
       // $form = new Form(new Service());
        //$user_id = intval(request('user_id'));
       $form = new Form(new Custregister()); // Use the Business model

     
   

            $form->hidden('service_assign', 'Assign_To')->options(Users::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required');
        $form->hidden('service_remarks', __('Remarks'));
        return $form;

    }
}