<?php

namespace App\Admin\Controllers;

use App\Models\Project;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class ProjectController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Project';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new  Project());
        $grid->column('id',__('id'));
        $grid->column('project_code',__('project_code')); 
        $grid->column('project_name',__('project_name'));  
        $grid->column('active',__('active'))->display(function ($active) {
           if($active ===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});
       

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     *@click and view projects
     */
    protected function detail($id) 
    {
        
        $show = new Show(Project::findOrFail($id));
        $show->field('id',__('id'));
        $show->field('project_code',__('project_code'));
        $show->field('project_name',__('project_name'))->setWidth(4, 2);
        $show->field('active',__('active'))->as(function ($active) {
           if($active===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});
       
        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */


    protected function form() //form add/edit
    {
        $form = new Form(new Project());
        $form->text('project_code',__('project_code'));
        $form->text('project_name',__('project_name'))->setWidth(4, 2);
        $form->switch('active', __('active'))->states(Constant::STATUS)->default(1);
        return $form;
    }
}