<?php

namespace App\Admin\Controllers;

use App\Http\Controllers\Controller;
use Encore\Admin\Controllers\Dashboard;
use Encore\Admin\Layout\Column;
use App\Models\Custregister;
use Encore\Admin\Grid;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Layout\Content;
use Encore\Admin\Layout\Row;
 use Encore\Admin\Widgets\Box;
 use Carbon\Carbon;
 Use Encore\Admin\Widgets\Table;
 use DB;
 use Illuminate\Http\Request;
 use Encore\Admin\Facades\Admin;
 use Encore\Admin\Widgets\InfoBox;

class HomeController extends AdminController
{

 

    protected function custregisterGrid()
{
     $grid = new Grid(new Custregister());
         
          $loginId = Admin::user()->id;  
        
         if (Admin::user()->inRoles(['Administrator', 'Manager'])){
                $today = Carbon::today()->toDateString();
    $grid->model()->whereNotNull('created_id')->whereDate('created_at', $today)->where('appointment',1);
}
    else{
       
        $grid->model()->where(function ($query) use ($loginId) {
             $today = Carbon::today()->toDateString();
        $query->where('assign_to', $loginId)
              ->where('visits_status', 1)->whereDate('updated_at', $today);
    })->orWhere(function ($query) use ($loginId) {
         $today = Carbon::today()->toDateString();
        $query->where('data_assign', $loginId)
              ->where('data_status', 2)->whereDate('updated_at', $today);
    })->orWhere(function ($query) use ($loginId) {
         $today = Carbon::today()->toDateString();
        $query->where('created_id', $loginId)->whereDate('updated_at', $today);
             
    });
    }    

       $grid->model()->orderBy('id', 'desc')->take(10);
$slNo = 0; // Initialize the increment value

$grid->rows(function (Grid\Row $row) use (&$slNo) {
    $slNo++; 
    $row->column('Sl No', $slNo);
});
// Your custom column.
$grid->column('Sl No');

       // $grid->column('id',__('SL.NO'))->display(function ($id) {
   //$totalRecords = Custregister::count();
   // $position = $totalRecords - $this->getKey() + 1;
   // return $position;
//});
        $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        });
        $grid->column('call_time', __('Call Time'))->hide();
        $grid->column('candidate_name', __('Candidate Name'));
        $grid->column('fathers_name', __("Father's Name"));
        $grid->column('mothers_name', __("Mother's Name"))->hide();
        $grid->column('house_name', __('House Name'))->hide();
        $grid->column('mob_1', __('Mobile 1'));
         $grid->column('place', __('Place/Area'));
        $grid->column('mob_2', __('Mobile 2'))->hide();
        $grid->column('gender', __('Gender'));
        $grid->column('date_of_birth', __('Date Of Birth'))->hide();
        $grid->column('age', __('Age'))->hide();
        $grid->column('religion', __('Religion'));
        $grid->column('cast', __('Cast'))->hide();
        $grid->column('candidate_watsupno', __('Candidate WhatsApp Number'))->hide();
        $grid->column('candidate_email', __('Candidate Email'))->hide();
        $grid->column('workplace', __('Workplace'))->hide();
        $grid->column('qualification', __('Qualification'))->hide();
        $grid->column('remark', __('Remark'))->hide();
        $grid->column('task_status', __('task_status'))->hide();
       // $grid->column('follow_up', __('Follow Up'))->hide();
        $grid->column('appointment', __('Appointment'))->display(function ($appointment) {
            if($appointment === 2){
                return "No";
            }else{
                return "Yes";
            }})->hide();
        $grid->column('appointment_date', __('Appointment Date'))->hide();
        $grid->column('appointment_time', __('Appoinment_Time'))->hide();
        $grid->column('appointment_note', __('Appoinment_Note'))->hide();

             $grid->disableFilter();

 if (Admin::user()->inRoles(['Administrator', 'Manager'])){
   // $grid->model()->whereNotNull('created_id');
    $grid->column('user.name', __('Staff Name'));
}

          $grid->disableActions();
   
      $grid->disableCreateButton();
   

        return $grid;
    
             
           
    
    } 
   
    
    public function index(Content $content)
    {
      


        // $infoBox = new InfoBox('New Users', 'users', 'aqua', '/admin/users', '1024');

        // echo $infoBox->render();
       
     
$loginId = Admin::user()->id;

        return $content
           
          //  ->description('Description...')
           // ->row(Dashboard::title())
            //->title('')
               ->row(function (Row $row) use ($loginId) {
                //$Id = Admin::user()->isAdministrator();
        if (Admin::user()->inRoles(['Administrator', 'Manager'])) {
             
 
          
            $row->column(2, function (Column $column) use ($loginId) {
                $menuIdLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 29);
                
                //if ($menuIdLink->count() > 0) {

                   $today = Carbon::today()->toDateString();
                     
                     $appointment = DB::table('custregisters')
                    ->whereDate('created_at', $today) 
                    ->count();

                  //  $appointmentLink = url('/admin/custregister?d=1');

                   // $appointmentBoxContent = "<a href='$appointmentLink'><i class='fa fa-calendar'></i> Appointments: $appointment</a>";

                    $column->append( new InfoBox('Todays Customers', 'calendar', 'maroon-gradient', '/admin/custregister?d=1', $appointment));
                   // $column->append(new Box('Today Appointments', $appointmentBoxContent));
               // }
            });

            
                 $row->column(2, function (Column $column) use ($loginId) {
                         //$loginId = Admin::user()->id; 
                   //  $menuLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 36);
                     
                  //  if($menuLink ->count() >= 0){
                     $today = Carbon::today()->toDateString();
                        
                    $payment = DB::table('custregisters')->where('payment_reminder', $today)
                    ->whereNotNull('data_assign')
                    ->count();
 
                                    $column->append( new InfoBox('Payment Remainder', 'bell', 'yellow-gradient', '/admin/dataentry?d=4', $payment));
                                     
                 });   
/*
            $row->column(2, function (Column $column) use ($loginId) {
                $menuLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 36);

                if ($menuLink->count() >= 0) {
                     $free = DB::table('custregisters')
                    ->where('member_status', 0)
                    ->count();
                     $Advance = DB::table('custregisters')
                    ->where('member_status', 1)
                    ->count();
                     $paid = DB::table('custregisters')
                    ->where('member_status', 2)
                    ->count();
                  
                                

                    $appointmentLink = url('/admin/dataentry' );

                    $appointmentBoxContent = "<div class='payment-detail-row'> <a href='$appointmentLink'>Free: $free</a>
                                       
                                    </div>
                                    <div class='payment-detail-row'>
                                        <a href='$appointmentLink'>Advance: $Advance</a>
                                    </div>
                                    <div class='payment-detail-row'>
                                        <a href='$appointmentLink'>Paid: $paid</a>
                                    </div>";
            
                                
    
                                            $column->append(new Box('Payment Details', $appointmentBoxContent));
                }
            });
            */
        
            
             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('gender','Male')->count();
                 
                 //$content ="<i class='fa fa-male'></i> Male: $totalIds";
                 $column->append( new InfoBox('Male', 'male', 'maroon-gradient', '/admin', $totalIds));
                    //$column->append(new Box('Male',$content ));
            });

                 $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('gender','Female')->count();
                   // $content = "<i class='fa fa-female'></i> Female: $totalIds";
                    $column->append( new InfoBox('Female', 'female', 'yellow-gradient', '/admin', $totalIds));
                   // $column->append(new Box('Female',$content));
            });

            $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('visits_status', 1)->count();
                  //$content = "<i class='fa fa-users'></i> Visited Customers:$totalIds";
                  $column->append( new InfoBox('Visited Customers', 'users', 'maroon-gradient', '/admin', $totalIds));
                   // $column->append(new Box('Visited Customers', $content));
            });
            $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('appointment',1)->count();
                     //$content = "<i class='fa fa-users'></i> Customers:$totalIds";
                     $column->append( new InfoBox('Total Registered Customers', 'users', 'yellow-gradient', '/admin', $totalIds));
                    //$column->append(new Box('Total Registered Customers',  $content));
            });
            $row->column(6, function (Column $column) use ($loginId) {
                $column->append('<h3>Religion Wise Customers</h3>');
            });
            
            $row->column(6, function (Column $column) use ($loginId) {
                $column->append('<h3>Payment Details</h3>');
            });
             
        
    
               
 
              $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('religion', 'Christian')->count();
                 // $appointmentLink = url('/admin/custregister?d=3');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-male'></i> Christians: $totalIds";
                     $column->append( new InfoBox('Christians', 'user-circle', 'maroon-gradient', '/admin/custregister?d=3', $totalIds));
                    //$column->append(new Box('Christians', $content));
            });

           $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('religion', 'Hindu')->count();
                  // $appointmentLink = url('/admin/custregister?d=4');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-male'></i> Hindus: $totalIds";
                     $column->append( new InfoBox('Hindu', 'user-circle', 'yellow-gradient', '/admin/custregister?d=4', $totalIds));
                   // $column->append(new Box('Hindu',$content));
            });

           $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('religion', 'Muslim')->count();
                  // $appointmentLink = url('/admin/custregister?d=5');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-male'></i> Muslims: $totalIds";
                     $column->append( new InfoBox('Muslim', 'user-circle', 'maroon-gradient', '/admin/custregister?d=5', $totalIds));
                   // $column->append(new Box('Muslim',$content));
            });


             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('member_status', 0)->count();

                  //$appointmentLink = url('/admin/dataentry?d=6');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Free:$totalIds";
                     $column->append( new InfoBox('Free', 'money', 'yellow-gradient', '/admin/custregister?d=6', $totalIds));
                  //  $column->append(new Box('Free',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('member_status', 1)->count();
                //  $appointmentLink = url('/admin/dataentry?d=7');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Advance:$totalIds";
                     $column->append( new InfoBox('Advance', 'money', 'maroon-gradient', '/admin/custregister?d=7', $totalIds));
                   // $column->append(new Box('Advance',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('member_status', 2)->count();
                 // $appointmentLink = url('/admin/dataentry?d=8');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Paid:$totalIds";
                     $column->append( new InfoBox('Paid', 'money', 'yellow-gradient', '/admin/custregister?d=8', $totalIds));
                   // $column->append(new Box('Paid',$content));
            });
             $row->column(2, function (Column $column) use ($loginId) {
                
             
              $today = Carbon::today()->toDateString(); 
             $payment = DB::table('custregisters')->whereNotNull('data_assign') 
            ->whereNull('data_status')
             ->count();
             
                             $column->append( new InfoBox('Data Pending Works', 'bell', 'maroon-gradient', '/admin/dataentry?d=1', $payment));

                         
            
          });    
            $row->column(2, function (Column $column) use ($loginId)  {
                          
              // $roleId = Admin::user()->roles; 

               
              
                  
           $appointment = DB::table('custregisters')
              // Assuming 'created_at' stores the appointment date
             ->whereNotNull('service_assign')->whereNull('service_status')->count();
                 
              //   $appointmentLink = url('/admin/services?d=10'); 


               //  $appointmentBoxContent = "<a href='$appointmentLink'><i class='fa fa-calendar'></i>pending services:$appointment</a>";
                   
                 $column->append( new InfoBox(' Service Pending Works', 'bell', 'yellow-gradient', '/admin/services?d=1', $appointment));
                 //$column->append(new Box('service Pending Works', $appointmentBoxContent));
                    
             });
             $row->column(2, function (Column $column) use ($loginId) {

             
              $totalIds = Custregister::whereNull('visits_status')->whereNotNull('assign_to')->count();
                //$appointmentLink = url('/admin/businexecutive?d=2');
                   //$content = "<a href='$appointmentLink'><i class='fa fa-bell'></i> Pending:$totalIds"; 
                   $column->append( new InfoBox('Pending Business Appointments', 'bell', 'maroon-gradient', '/admin/businexecutive?d=2', $totalIds));
                //  $column->append(new Box('Pending Appointments',$content));
            
              });
              $row->column(2, function (Column $column) use ($loginId) {
                
                

                $totalIds = Custregister::where('appointment',0)->whereNotNull('created_id')->count();
                  // $appointmentLink = url('/admin/custregister?d=2');

                   //$content = "<a href='$appointmentLink'><i class='fa fa-bell'></i> Pending:$totalIds"; 
                   $column->append( new InfoBox('Pending Telecaller Appointments', 'bell', 'yellow-gradient', '/admin/custregister?d=2', $totalIds));
                    //$column->append(new Box('Pending Appointments',$content));
              
                });
                 $row->column(2, function (Column $column) use ($loginId) {
                  //$loginId = Admin::user()->id; 
             
              $today = Carbon::today()->toDateString(); 
             $payment = DB::table('custregisters')->where('calling_reminder', $today)
             ->whereNotNull('created_id')
             ->count();
            
                             $column->append( new InfoBox('Calling Remainder', 'bell', 'maroon-gradient', '/admin/custregister?d=9', $payment));

             
          });    
        }
        
    })

            ->row(function (Row $row) use ($loginId) {

                    

                  if (Admin::user()->isRole('BusinessExecutive')) {

                $row->column(2, function (Column $column) use ($loginId)  {
                
                 // $roleId = Admin::user()->roles; 
           

                   $menuIdLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 29);
                  if($menuIdLink->count() >= 0){
                    $today = Carbon::today()->toDateString(); // Get today's date in 'Y-m-d' format
                     
                     $appointment = DB::table('custregisters')
                    ->whereDate('created_at', $today) // Assuming 'created_at' stores the appointment date
                    ->where('appointment', 1)->where('assign_to', $loginId)->whereNull('visits_status') ->count();

                    //$appointmentLink = url('/admin/businexecutive?d=1' );

                   // $appointmentBoxContent = "<a href='$appointmentLink'><i class='fa fa-calendar'></i> Appointments: $appointment</a>";

                    $column->append( new InfoBox('Today Appointments', 'calendar', 'maroon-gradient', '/admin/businexecutive?d=1', $appointment));
                   // $column->append(new Box('Today Appointments', $appointmentBoxContent));
                       }
                });
               
                $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('visits_status',1)->where('assign_to', $loginId)->where('member_status', 0)->count();
                  //  $appointmentLink = url('/admin/businexecutive?d=6');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Free:$totalIds";
                     $column->append( new InfoBox('Free', 'money', 'yellow-gradient', '/admin/businexecutive?d=6', $totalIds));
                  //  $column->append(new Box('Free',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('visits_status',1)->where('assign_to', $loginId)->where('member_status', 1)->count();
                // $appointmentLink = url('/admin/businexecutive?d=7');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Advance:$totalIds";
                     $column->append( new InfoBox('Advance', 'money', 'maroon-gradient', '/admin/businexecutive?d=7', $totalIds));
                   // $column->append(new Box('Advance',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('visits_status',1)->where('assign_to', $loginId)->where('member_status', 2)->count();
                  //  $appointmentLink = url('/admin/businexecutive?d=8');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Paid:$totalIds";
                     $column->append( new InfoBox('Paid', 'money', 'yellow-gradient', '/admin/businexecutive?d=8', $totalIds));
                   // $column->append(new Box('Paid',$content));
            });
                 $row->column(2, function (Column $column) use ($loginId) {

                $totalIds = Custregister::whereNull('visits_status')->where('assign_to', $loginId)->count();
                  //$appointmentLink = url('/admin/businexecutive?d=2');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-bell'></i> Pending:$totalIds"; 
                     $column->append( new InfoBox('Pending Appointments', 'bell', 'maroon-gradient', '/admin/businexecutive?d=2', $totalIds));
                  //  $column->append(new Box('Pending Appointments',$content));
                });

                $row->column(2, function (Column $column) use ($loginId) {
                   //$form = new \Encore\Admin\Widgets\Box();
                    //$loginId = Admin::user()->id;

                $totalIds = Custregister::where('assign_to', $loginId)->count();
                   // $content = "<i class='fa fa-users'></i>Customers : $totalIds"; 
                    $column->append( new InfoBox('Total Custmers', 'users', 'yellow-gradient', '/admin', $totalIds));
                   // $column->append(new Box('Total Custmers',$content));
                });
                  }
            })

              ->row(function (Row $row) use ($loginId) {

                     $Id =Admin::user()->id;
                  if (Admin::user()->isRole('DataEntry')) {

                $row->column(2, function (Column $column)  use ($loginId) {
                         //$loginId = Admin::user()->id; 
                     $menuLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 36);

                   if( $menuLink->count() >= 0){
                    $today = Carbon::today()->toDateString(); // Get today's date in 'Y-m-d' format
                     
                     $appointment = DB::table('custregisters')
                    ->whereDate('updated_at', $today) 
                    ->where('visits_status', 1)->where('data_assign', $loginId) 
                    ->count();

                 //   $appointmentLink = url('/admin/dataentry?d=3' );

                 //   $appointmentBoxContent = "<a href='$appointmentLink'><i class='fa fa-calendar'></i> Appointments:$appointment</a>";

                    $column->append( new InfoBox('Today Appointments', 'calendar', 'yellow-gradient', '/admin/dataentry?d=3', $appointment));
                 //   $column->append(new Box('Today Appointments', $appointmentBoxContent));
                       }
                });
                 $row->column(2, function (Column $column) use ($loginId) {
                
             
              $today = Carbon::today()->toDateString(); 
             $payment = DB::table('custregisters')->where('data_assign', $loginId) 
             ->where('visits_status', 1)->whereNull('data_status')
             ->count();
             
                             $column->append( new InfoBox('Pending Works', 'bell', 'maroon-gradient', '/admin/dataentry?d=1', $payment));

                         
            
          });      

                 $row->column(2, function (Column $column) use ($loginId) {
                         //$loginId = Admin::user()->id; 
                     $menuLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 36);
                     
                    if($menuLink ->count() >= 0){
                     $today = Carbon::today()->toDateString(); 
                    $payment = DB::table('custregisters')->where('payment_reminder', $today)
                    ->where('data_assign',$loginId)
                    ->count();
                    //   $appointmentLink = url('/admin/dataentry?d=4');
                    //   $paymentReminderBoxContent = "<a href='[$appointmentLink'><div class='payment-reminder'><i class='fa fa-bell'></i> 
                    //                     Payment Reminder: $payment
                    //                 </div>";  
                                    $column->append( new InfoBox('Payment Remainder', 'bell', 'yellow-gradient', '/admin/dataentry?d=4', $payment));

                                // $column->append(new Box('Payment Remainder',$paymentReminderBoxContent));
                    }
                 });         

                $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('data_status',2)->where('data_assign', $loginId)->where('member_status', 0)->count();
                       //$appointmentLink = url('/admin/dataentry?d=6');
                    // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Free:$totalIds";
                     $column->append( new InfoBox('Free', 'money', 'maroon-gradient', '/admin/dataentry?d=6', $totalIds));
                    //$column->append(new Box('Free',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('data_status',2)->where('data_assign', $loginId)->where('member_status', 1)->count();
                    // $appointmentLink = url('/admin/dataentry?d=7');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Advance:$totalIds";
                     $column->append( new InfoBox('Advance', 'money', 'yellow-gradient', '/admin/dataentry?d=7', $totalIds));
                   // $column->append(new Box('Advance',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('data_status',1)->where('data_assign', $loginId)->where('member_status', 2)->count();
                    //$appointmentLink = url('/admin/dataentry?d=8');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Paid:$totalIds";
                     $column->append( new InfoBox('Paid', 'money', 'maroon-gradient', '/admin/dataentry?d=8', $totalIds));
                    //$column->append(new Box('Paid',$content));
            });
               

                $row->column(2, function (Column $column)  use ($loginId) {
                   //$form = new \Encore\Admin\Widgets\Box();
                   // $loginId = Admin::user()->id;

                $totalIds = Custregister::where('data_status', 2)->where('data_assign', $loginId)->count();
                   // $content = "<i class='fa fa-users'></i>Customers :$totalIds"; 
                    $column->append( new InfoBox('Total Custmers', 'users', 'yellow-gradient', '/admin/dataentry', $totalIds));
                   // $column->append(new Box('Total Custmers',$content));
                });

                  }

            }) ->row(function (Row $row) use ($loginId) {

                  if (Admin::user()->isRole('Telecaller')) {

                $row->column(2, function (Column $column) use ($loginId)  {
                
                 // $roleId = Admin::user()->roles; 

                   $menuIdLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 28);
                  if($menuIdLink->count() >= 0){
                    $today = Carbon::today()->toDateString(); // Get today's date in 'Y-m-d' format
                     
                     $appointment = DB::table('custregisters')
                    ->whereDate('created_at', $today) // Assuming 'created_at' stores the appointment date
                    ->where('created_id', $loginId) // Filter for 'appointment' true (1)
                    ->count();
                    
                  //  $appointmentLink = url('/admin/custregister?d=1');

                 //   $appointmentBoxContent = "<a href='$appointmentLink'><i class='fa fa-calendar'></i> Appointments:$appointment</a>";

                    $column->append( new InfoBox('Today Appointments', 'users', 'maroon-gradient', '/admin/custregister?d=1', $appointment));
                    //$column->append(new Box('Today Appointments', $appointmentBoxContent));
                       }
                });
               
                $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('created_id', $loginId)->where('member_status', 0)->count();
                      // $appointmentLink = url('/admin/custregister?d=6');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Free:$totalIds";
                     $column->append( new InfoBox('Free', 'money', 'yellow-gradient', '/admin/custregister?d=6', $totalIds));

//                    $column->append(new Box('Free',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('created_id', $loginId)->where('member_status', 1)->count();
                 // $appointmentLink = url('/admin/custregister?d=7');
                   //  $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Advance:$totalIds";
                     $column->append( new InfoBox('Advance', 'money', 'maroon-gradient', '/admin/custregister?d=7', $totalIds));
                  //  $column->append(new Box('Advance',$content));
            });

             $row->column(2, function (Column $column) use ($loginId) {
                 $totalIds = Custregister::where('created_id', $loginId)->where('member_status', 2)->count();
                 // $appointmentLink = url('/admin/custregister?d=8');
                     //$content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Paid:$totalIds";
                     $column->append( new InfoBox('Paid', 'money', 'yellow-gradient', '/admin/custregister?d=8', $totalIds));
                   // $column->append(new Box('Paid',$content));
            });
                 $row->column(2, function (Column $column) use ($loginId) {

                $totalIds = Custregister::where('appointment',0)->where('created_id', $loginId)->count();
                  // $appointmentLink = url('/admin/custregister?d=2');

                   //$content = "<a href='$appointmentLink'><i class='fa fa-bell'></i> Pending:$totalIds"; 
                   $column->append( new InfoBox('Pending Appointments', 'bell', 'maroon-gradient', '/admin/custregister?d=2', $totalIds));
                    //$column->append(new Box('Pending Appointments',$content));
                });

                $row->column(2, function (Column $column) use ($loginId) {

                $totalIds = Custregister::where('created_id', $loginId)->count();
                     //$content = "<i class='fa fa-users'></i>Customers :$totalIds"; 
                     $column->append( new InfoBox('Total Custmers', 'users', 'yellow-gradient', '/admin/custregister', $totalIds));
                   // $column->append(new Box('Total Custmers',$content));
                });
                  $row->column(2, function (Column $column) use ($loginId) {
                  //$loginId = Admin::user()->id; 
             
              $today = Carbon::today()->toDateString(); 
             $payment = DB::table('custregisters')->where('calling_reminder', $today)
             ->where('created_id',$loginId)
             ->count();
            
                             $column->append( new InfoBox('Calling Remainder', 'bell', 'maroon-gradient', '/admin/custregister?d=9', $payment));

             
          });
                  }
                        }) ->row(function (Row $row) use ($loginId) {

                            if (Admin::user()->isRole('ServiceExecutive')) {
          
                          $row->column(2, function (Column $column) use ($loginId)  {
                          
                           // $roleId = Admin::user()->roles; 
          
                             $menuIdLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 31);
                            if($menuIdLink->count() >= 0){
                           
                               
                            $appointment = DB::table('custregisters')
                               // Assuming 'created_at' stores the appointment date
                              ->where('service_assign', $loginId) // Filter for 'appointment' true (1)
                              ->count();
                              
                           //   $appointmentLink = url('/admin/services?d=10');

          
                            //  $appointmentBoxContent = "<a href='$appointmentLink'><i class='fa fa-calendar'></i>pending services:$appointment</a>";
                                
                              $column->append( new InfoBox('Pending Works', 'calendar', 'maroon-gradient', '/admin/services?d=1', $appointment));
                              //$column->append(new Box('Pending Works', $appointmentBoxContent));
                                 }
                          });
                         
                          $row->column(2, function (Column $column) use ($loginId) {
                           $totalIds = Custregister::where('service_assign', $loginId)->where('member_status', 0)->count();
                                // $appointmentLink = url('/admin/services?d=6');
                               //$content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Free:$totalIds";
                               $column->append( new InfoBox('Free', 'users', 'yellow-gradient', '/admin/services?d=6', $totalIds));
                            //  $column->append(new Box('Free',$content));
                      });
          
                       $row->column(2, function (Column $column) use ($loginId) {
                           $totalIds = Custregister::where('service_assign', $loginId)->where('member_status', 1)->count();
                            $appointmentLink = url('/admin/services?d=7');
                              // $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Advance:$totalIds";
                               $column->append( new InfoBox('Advance', 'users', 'maroon-gradient', '/admin/services?d=7', $totalIds));
                             // $column->append(new Box('Advance',$content));
                      });
          
                       $row->column(2, function (Column $column) use ($loginId) {
                           $totalIds = Custregister::where('service_assign', $loginId)->where('member_status', 2)->count();
                            //$appointmentLink = url('/admin/services?d=8');
                             //  $content = "<a href='$appointmentLink'><i class='fa fa-money'></i> Paid:$totalIds";
                               $column->append( new InfoBox('Paid', 'users', 'yellow-gradient', '/admin/services?d=8', $totalIds));
                             // $column->append(new Box('Paid',$content));
                      });
                      $row->column(2, function (Column $column) use ($loginId) {
          
                        $totalIds = Custregister::where('service_assign', $loginId)->whereNotNull('meetup_date')->count();
                            // $content = "<i class='fa fa-meetup'></i>MeetUp :$totalIds"; 
                             $column->append( new InfoBox('Total MeetUp', 'meetup', 'maroon-gradient', '/admin/services', $totalIds));
                            //$column->append(new Box('Total MeetUp',$content));
                        });
                           
                          $row->column(2, function (Column $column) use ($loginId) {
          
                          $totalIds = Custregister::where('service_assign', $loginId)->count();
                              // $content = "<i class='fa fa-users'></i>Customers :$totalIds"; 
                               $column->append( new InfoBox('Total Custmers', 'users', 'yellow-gradient', '/admin/services', $totalIds));
                             // $column->append(new Box('Total Custmers',$content));
                          });
                            }
                                  })->row(function (Row $row) use ($loginId) {
                // Existing code...

                //Add a new row for the grid
                $row->column(12, function (Column $column) {
                    $column->append($this->custregisterGrid());
                });
            });
    }

}
