<?php
namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Complaints;
use Encore\Admin\Controllers\AdminController;
use App\Models\Constant;
use Carbon\Carbon;
use Encore\Admin\Facades\Admin;
Use Encore\Admin\Widgets\Table;
Use Illuminate\Support\Str;

class ComplaintBoxController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Complaint Box';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new  Complaints());
      
       $loginId = Admin::user()->id;  

         if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->whereNotNull('assign_to');
}
    else{
     
         $grid->model()->where('assign_to', $loginId);
    }   
      
         $grid->model()->orderBy('id', 'desc');
        $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
        $grid->column('costumer_name',__('Customer Name')); 
       // $grid->column('wedline_id',__('Wedline ID')); 
        $grid->column('contact_number',__('Contact Number'));
       
        $grid->column('complaint','Complaints')->ucfirst()->substr(0, 30)->modal('Registered Complaints', function ($model) {

            $comments = $model->complaints('id')->take(10)->get()->map(function ($comment) {
                return $comment->only('complaint');
            });
            
                return new Table(['complaints'],$comments->toArray());
            });
        $grid->column('status', __('Status'));
          $grid->column('user.name', __('Staff Name'));
  $grid->disableCreateButton();

      $grid->actions(function ($actions) {
            //$actions->disableEdit();
             $actions->disableView();// Disable the view action
        });
          $grid->quickSearch('costumer_name', 'wedline_id', 'contact_number', 'createdby', 'date');

       $grid->disableFilter();
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     *@click and view projects
     */
    protected function detail($id) 
    {
        
        $show = new Show(Complaints::findOrFail($id));
       // $show->field('id',__('Id'));
         $show->field('costumer_name',__('Costumer Name')); 
        $show->field('wedline_id',__('Wedline ID')); 
        $show->field('contact_number',__('Contact Number'));
       
        $show->field('complaint',__('Complaint'));
         $show->field('date',__('Date'));  

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */


    protected function form() //form add/edit
    {
         $loginId = Admin::user()->name;
        $form = new Form(new Complaints());
        $form->text('costumer_name',__('Costumer Name'))->readonly();
        $form->text('wedline_id',__('Wedline ID'))->readonly();
       $form->mobile('contact_number',__('Contact Number'))->options(['mask' => '+99 999 999 9999'])->setWidth(4, 2)->readonly();
         $form->datetime('date',__('Registered Date'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a')->readonly();
        $form->textarea('complaint',__('Complaint'))->readonly();
       
        $form->table('follow_up','Follow up', function ($table) {
               
                $table->text('solution')->rules('required');
                $table->datetime('date')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
            });
       $form->select('status', __('Status'))->options(['pending'=>'pending','Progress'=>'Progress','Solved'=>'Solved']);
        $form->hidden('created_id')->default( $loginId);
    
        return $form;
    }
}