<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Visits;
use App\Models\Users;
use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Carbon\Carbon;

class VisitassignController extends AdminController
{
    protected $title = 'Visit Assign';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Custregister());

         $grid->model()->where('appointment', 1)->where('task_status',0);

        // Define grid columns
        $grid->column('id', __('ID'));
       // $grid->column('vca_id', __('Customer ID'));
        $grid->column('date', __('Entry Date'));
        $grid->column('candidate_name', __('Customer Name'));
        $grid->column('appointment_date', __('Appointment Date'));
        $grid->column('appointment_time', __('Appointment Time'));
        $grid->column('appointment_note', __('Appointment Note'));
        $grid->column('house_name', __('Address'));
        $grid->column('remarks', __('Remarks'))->editable('textarea');
        $grid->column('assign_to', __('Assign To'))->editable('select',(Users::pluck('name','id')));
        //$grid->column('created_at', __('Created At'));
       // $grid->column('updated_at', __('Updated At'));
        $grid->disableCreateButton();

       
      $grid->actions(function ($actions) {
            $actions->disableEdit();
             $actions->disableView();// Disable the view action
        });
        
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Custregister::findOrFail($id));

        // Define detail view fields
        $show->field('id', __('ID'));
        $show->field('vca_id', __('Customer ID'));
        $show->field('date', __('Entry Date'));
        $show->field('candidate_name', __('Customer Name'));
        $show->field('appointment_date', __('Appointment Date'));
        $show->field('appointment_time', __('Appointment Time'));
        $show->field('appointment_note', __('Appointment Note'));
        $show->field('house_name', __('Address'));
        $show->field('assign_to', __('Assign To'));
        $show->field('remarks', __('Remarks'));
        $show->field('created_at', __('Created At'));
        $show->field('updated_at', __('Updated At'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
       

    $form = new Form(new Custregister());

   
     /*   $form->select('vca_id', 'Customer ID')->options([$custregister->id => $custregister->id])
            ->default($custregister->id)->readonly();
        $form->date('date', 'Entry Date')->default($custregister->date)->rules('required'); // Include the date field and make it required
        $form->text('candidate_name', 'Customer Name')->default($custregister->candidate_name)->rules('required');
        $form->date('appointment_date', 'Appointment Date')->default($custregister->appointment_date)->rules('required');
        $form->time('appointment_time', 'Appointment Time')->default($custregister->appointment_time)->rules('required');
        $form->textarea('appointment_note', 'Appointment Note')->default($custregister->appointment_note)->rules('required');
        $form->text('house_name', 'Address')->default($custregister->house_name)->rules('required'); 
        */
        
        $form->hidden('assign_to', 'Assign_To')->options(Users::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required');
        $form->hidden('remarks', __('Remarks'));
       
    return $form;
    
}
public function update_operation($id)
  {
      return Admin::form(Visits::class, function (Form $form) {
          $form->textarea('remarks');
          $form->text('assign_to', 'Assign_To')->options(Users::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required');
      })->update($id);
  }
}