<?php

namespace App\Admin\Controllers;

use App\Http\Controllers\Controller;
use Encore\Admin\Controllers\Dashboard;
use Encore\Admin\Layout\Column;
use App\Models\Custregister;
use Encore\Admin\Layout\Content;
use Encore\Admin\Layout\Row;
 use Encore\Admin\Widgets\Box;
 use Carbon\Carbon;
 use DB;
 use Encore\Admin\Facades\Admin;

class HomeController extends Controller
{
    public function index(Content $content)
    {
        


        return $content
            ->title('Dashboard')
            ->description('Description...')
            ->row(Dashboard::title())
            ->row(function (Row $row) {
                

                $row->column(2, function (Column $column) {
                  $loginId = Admin::user()->id;  

                 // $roleId = Admin::user()->roles; 

                   $menuIdLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 29);
                  if($menuIdLink->count() > 0){
                    $today = Carbon::today()->toDateString(); // Get today's date in 'Y-m-d' format
                     
                     $appointment = DB::table('custregisters')
                    ->whereDate('created_at', $today) // Assuming 'created_at' stores the appointment date
                    ->where('appointment', 1)->where('assign_to', $loginId) // Filter for 'appointment' true (1)
                    ->count();

                    $appointmentLink = url('/admin/businexecutive' );

                    $appointmentBoxContent = "<a href='$appointmentLink'>$appointment</a>";

                    $column->append(new Box('Today Appointments', $appointmentBoxContent));
                       }

                     $menuLink = DB::table('admin_role_menu')->where('role_id', $loginId)->where('menu_id', 36);

                    if($menuLink ->count() >= 0){
                     $today = Carbon::today()->toDateString();

                     $free = DB::table('custregisters')
                    ->where('member_status', 0)->where('data_assign',$loginId)
                    ->count();
                     $Advance = DB::table('custregisters')
                    ->where('member_status', 1)->where('data_assign',$loginId)
                    ->count();
                     $paid = DB::table('custregisters')
                    ->where('member_status', 2)->where('data_assign',$loginId)
                    ->count();
                   
                    $payment = DB::table('custregisters')->where('payment_reminder', $today)
                    ->where('data_assign',$loginId)
                    ->count();
                                
                                

                    $appointmentLink = url('/admin/dataentry' );

                    $appointmentBoxContent = "<div class='payment-detail-row'> <a href='$appointmentLink'>Free: $free</a>
                                       
                                    </div>
                                    <div class='payment-detail-row'>
                                        <a href='$appointmentLink'>Advance: $Advance</a>
                                    </div>
                                    <div class='payment-detail-row'>
                                        <a href='$appointmentLink'>Paid: $paid</a>
                                    </div>";
            
                                 $paymentReminderBoxContent = "<div class='payment-reminder'>
                                        Payment Reminder: $payment
                                    </div>";
    
                                            $column->append(new Box('Payment Details', $appointmentBoxContent));

                                            $column->append(new Box('Payment Remainder',$paymentReminderBoxContent));
                       }

                });

                $row->column(8, function (Column $column) {
                
                    $column->append(new Box('Notifications','To view the full profile and connect with this candidate, log in to your Weline Matrimony account using the link below:'));
                });
               

                $row->column(2, function (Column $column) {
                   //$form = new \Encore\Admin\Widgets\Box();
                    $loginId = Admin::user()->id;

                $totalIds = Custregister::where('visits_status', 1)->where('assign_to', $loginId)->count();
                    $column->append(new Box('Total Custmers',$totalIds));
                });

            });
                
            
    }
}
