<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\Users;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Custregister;
use App\Models\Notifications;
use Carbon\Carbon;
use Encore\Admin\Facades\Admin;
use Encore\Admin\Widgets\InfoBox;


class NotificationsController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Notifications';


    /**
     * Make a grid builder.
     *
     * @return Grid
     */


    protected function grid()
    {
      
      

        $href_user= env('APP_URL')."admin/notify";
      $grid = new Grid(new  Notifications());
      $date = intval(request('d'));
      $loginId = Admin::user()->id;
      $today = now()->toDateString();
         if ($date === 4) {
         if (Admin::user()->inRoles(['Administrator', 'Manager'])){
           
   $grid->model()->whereDate('created_at', $today)->where('read',0);
}
   else{
    
        $grid->model()->where('created_id', $loginId)->whereDate('created_at', $today)->where('read',0);
   }   
}  

       $grid->model()->orderBy('id', 'desc');
        $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
        //$grid->column('cust_name',__('Costumer Name')); 
        $grid->column('Costumer Name')->display(function () use($href_user){
            $id = $this->customer_id;
            $user_name =  $this->cust_name;
         
        return "<a href='custregister/$id/edit?'target='_blank' rel='nooper'> $user_name</a>";
        });
        $grid->column('note',__('note')); 
        $states = [
            'on' => ['value' => 1, 'text' => 'read', 'color' => 'primary'],
            'off' => ['value' => 0, 'text' => 'hold', 'color' => 'default'],
        ];
        $grid->column('read')->switch($states);
 


        return $grid;

    // Define the HTML content for the grid

    // $date = intval(request('d'));
    // $loginId = Admin::user()->id;
    // $today = now()->toDateString();
    // $notifications = [];
    
    // if ($date === 4) {
    //     if (Admin::user()->inRoles(['Administrator', 'Manager'])) {
    //         $notifications = Notifications::whereDate('created_at', $today)->get();
    //     } else {
    //         $notifications = Notifications::where('created_id', $loginId)
    //             ->whereDate('created_at', $today)
    //             ->select('cust_name', 'note')
    //             ->get();
    //     }
    // }
    
    // $grid = '';
    
    // if (!empty($notifications)) {
    //     $grid .= '<div class="notification-box" style="background-color: #ffeebb; border: 1px solid #f0c36d; padding: 10px; margin: 10px 0; border-radius: 5px;">';
    
    //     foreach ($notifications as $notification) {
    //         $grid .= '<p>Customer Name: ' . $notification->cust_name . '</p>';
    //         $grid .= '<p>Note: ' . $notification->note . '</p>';
    //         $grid .= '<hr>';
    //     }
    
    //     $grid .= '</div>';
    // }
    
    
  //return $grid;
 }
    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Service::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('time', __('Time'));
        $show->field('name', __('Name'));
        $show->field('id_number', __('ID Number'));
        $show->field('qualification', __('Qualification'));
        $show->field('occupation', __('Occupation'));
        $show->field('work_place', __('Work Place'));
        $show->field('matching_nam', __('Matching Name'));
        $show->field('m_id_number', __('M ID Number'));
        $show->field('m_qualification', __('M Qualification'));
        $show->field('m_occupation', __('M Occupation'));
        $show->field('m_work_place', __('M Work Place'));
        $show->field('matching_statuss', __('Matching Status'));
        $show->field('status_date_time', __('Status Date & Time'));
        $show->field('meetup_date', __('Meetup Date'));
        $show->field('meetup_status', __('Meetup Status'));
        $show->field('marriage_status', __('Marriage Status'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
       // $form = new Form(new Service());
        //$user_id = intval(request('user_id'));
       $form = new Form(new Notifications()); // Use the Business model

     
   

          
        $form->switch('read', __('Read'));
        return $form;

    }
}