<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visits', function (Blueprint $table) {
            $table->id();
            $table->integer('vca_id');
            $table->date('date');
            $table->string('candidate_name');
            $table->date('appointment_date');
            $table->time('appointment_time');
            $table->string('appointment_note');
            $table->string('house_name');
            $table->string('assign_to');
            $table->timestamps();
        });
        $table->foreign('vca_id')->references('id')->on('custregisters')->onDelete('cascade');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visits');
    }
}
