<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDataentriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dataentries', function (Blueprint $table) {

            $table->id();
            $table->date('date');
            $table->time('time');
            $table->boolean('profile_verification')->default(true);
            $table->dateTime('registration_d/t');
            $table->string('registration_status')->nullable();
            $table->string('pending_reminder');
            $table->integer('wm_id_no');
            $table->string('matching_profile');
            $table->dateTime('date_time');
            $table->string('matching_profile_status')->nullable();
            $table->string('payment_chance')->nullable();
            $table->string('payment_reminder');
            $table->string('member_status')->nullable();
            $table->string('plan_details');
            $table->string('invoice_no');
            $table->string('offer_details');
            // Add any other fields as needed
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dataentries');
    }
}
