<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBusinessesTable extends Migration
{
     /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('businesses', function (Blueprint $table) {
            $table->id();
            $table->foreignId("cust_id")->constrained("custregister")->onDelete('cascade');
            $table->date('date');
            $table->time('in_time')->nullable();
            $table->text('expectations')->nullable();
            $table->text('family_status')->nullable();
            $table->text('house_details')->nullable();
            $table->text('service_charge_details')->nullable();
            $table->text('matching_profile_details')->nullable();
            $table->text('payment_chance')->nullable();
            $table->text('payment_details')->nullable();
            $table->text('offer')->nullable();
            $table->string('location')->nullable();
            $table->string('landmark')->nullable();
             $table->string('latitude')->nullable();
             $table->string('longitude')->nullable();
            $table->string('map')->nullable();
            $table->time('out_time')->nullable();
            $table->text('remark')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('businesses');
    }
}