<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
             $table->foreignId("pack_id")->constrained("categories")->onDelete('cascade');
              $table->string('package_name');
              $table->Integer('night');
                $table->Integer('day');
               $table->string('package_description');
               $table->string('image')->nullable();
                 $table->Integer('order');
             $table->Integer('active')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('packages');
    }
}
