<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $table = 'services';

     protected $casts = [
        
         'matching_profile' =>'json',
    ];

    protected $fillable = [
        'date',
        'time',
        'name',
        'id_number',
        'qualification',
        'occupation',
        'work_place',
        'matching_name',
        'm_id_numberr',
        'm_qualification',
        'm_occupation',
        'm_work_place',
        'matching_status',
        'status_date_time',
        'meetup_date',
        'meetup_status',
        'marriage_status',
        'matching_profile',
    ];

    public function setColumnNameAttribute($value)
    {
        $this->attributes['matching_profile'] = json_encode(array_values($value));

       

    }
}