<?php

namespace App\Http\Controllers;

use App\Models\Testimonial;

use Illuminate\Http\Request;
use Validator;

class PublicTestimonialController extends Controller
{
    public function getTestimonial(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'exists:testimonials,id',
       
        ]);
        if ($validator->fails()) {
            return $validator->errors();
        }

        $id = $request->id;
        if($id){
            $tes = Testimonial::find($id);
        }else{
            $tes = Testimonial::get();
            if($tes->isEmpty()){
                return response()->json(["message" =>"Empty data"]);
            }
        }
        
        return response()->json(["message" =>"success","data"=>$tes]);
    }
}
