<?php

namespace App\Admin\Controllers;

use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Encore\Admin\Filters\Filter;
use Illuminate\Http\Request;
use App\Models\Users;
use DB;

class StaffReportsController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Custmer wise Report';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
          $grid = new Grid(new Custregister());

      $grid->column('id', __('ID'));
      $grid->column('candidate_name', __('Candidate Name'));
     // $grid->column('fathers_name', __("Father's Name"));
      //$grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
      $grid->column('mob_1', __('Mobile 1'));
      //$grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
      //$grid->column('cast', __('Cast'));

       $grid->filter(function ($filter) {
        $filter->disableIdFilter();
        $filter->equal('data_assign', 'Staff Name')->select(Users::pluck('name', 'id'));
          
    $filter->between('date', 'Date Range')->date();
    });

    
      $grid->disableCreateButton();

      $grid->actions(function ($actions) {
            $actions->disableEdit();
             $actions->disableView();// Disable the view action
        });

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Career::findOrFail($id));
        
        $show->field('id',__('ID'))->setWidth(4, 2);
        $show->field('jobtitle',__('Job-Title'))->setWidth(4, 2);
        $show->field('description',__('Description'));
        $show->field('Active',__('Active'))->setWidth(2, 2);

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Career());
        
       
        $form->text('jobtitle',__('Job-Title'))->setWidth(4, 2)->rules('required|min:2');
        $form->textarea('description',__('Description'));
        $form->switch('Active',__('Active'))->states(Constant::STATUS)->default(1);
       
        return $form;
    }

}
