<?php

namespace App\Admin\Controllers;

use App\Models\Project;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use App\Models\Permissions;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;


class PermissionsController extends AdminController
{
public function up()
    {
        Schema::table('admin.database.permissions_table', function (Blueprint $table) {
            $table->column('id',__('id'));
            $table->column('name',__('name')); 
            $table->column('slug',__('slug'));
            $table->column('http_method',__('http_method'));  
            $table->column('http_path',__('http_path'));    
        });
    }

    public function down()
    {
        Schema::table('admin.database.permissions_table', function (Blueprint $table) {
            $table->column('id',__('id'));
            $table->column('name',__('name')); 
            $table->column('slug',__('slug')); 
            $table->column('http_method',__('http_method'));   
            $table->column('http_path',__('http_path'));   
        });
    }
    public function create()
    {
        // check permission, only the roles with permission `create-post` can visit this action
        Permission::check('create-');
    }
}