<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Custregister;
use App\Models\Visits;
use App\Models\Country;
use App\Models\State;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;

use App\Models\Religion;
use App\Models\Cast;
use Carbon\Carbon;
use Encore\Admin\Facades\Admin;

class CustRegisterController extends AdminController
{
  /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Customer';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Custregister());
        $grid->model()->orderBy('id', 'desc');
        $grid->column('id', __('ID'));
       // $grid->column('id', __('SL.NO'))->display(function ($id) {
        
           // $totalRecords = Custregister::count();
         
            //$displayedId = $totalRecords - $id + 1;
            //return $displayedId;
      // });
        $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        });
        $grid->column('call_time', __('Call Time'));
        $grid->column('candidate_name', __('Candidate Name'));
        $grid->column('fathers_name', __("Father's Name"));
        $grid->column('mothers_name', __("Mother's Name"));
        $grid->column('house_name', __('House Name'));
        $grid->column('mob_1', __('Mobile 1'));
        $grid->column('mob_2', __('Mobile 2'));
        $grid->column('gender', __('Gender'));
        $grid->column('date_of_birth', __('Date Of Birth'));
        $grid->column('age', __('Age'));
        $grid->column('religion', __('Religion'));
        $grid->column('cast', __('Cast'));
        $grid->column('candidate_watsupno', __('Candidate WhatsApp Number'));
        $grid->column('candidate_email', __('Candidate Email'));
        $grid->column('workplace', __('Workplace'));
        $grid->column('qualification', __('Qualification'));
        $grid->column('remark', __('Remark'));
        $grid->column('task_status', __('task_status'));
        $grid->column('follow_up', __('Follow Up'));
        $grid->column('appointment', __('Appointment'))->display(function ($appointment) {
            if($appointment === 2){
                return "No";
            }else{
                return "Yes";
            }});;
        $grid->column('appointment_date', __('Appointment Date'));
        $grid->column('appointment_time', __('Appoinment_Time'));
        $grid->column('appointment_note', __('Appoinment_Note'));

        $grid->filter(function ($filter) {
        $filter->disableIdFilter();
          
    $filter->like('candidate_name', 'Name');
    $filter->like('age', 'Age');
    $filter->like('religion', 'Religion');
   
    });

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {   
         $show = new Show(Custregister::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('call_time', __('Call Time'));
        $show->field('candidate_name', __('Candidate Name'));
        $show->field('fathers_name', __("Father's Name"));
        $show->field('mothers_name', __("Mother's Name"));
        $show->field('house_name', __('House Name'));
        $show->field('mob_1', __('Mobile 1'));
        $show->field('mob_2', __('Mobile 2'));
        $show->field('gender', __('Gender'));
        $show->field('date_of_birth', __('Date of Birth'));
        $show->field('religion', __('Religion'));
        $show->field('cast', __('Cast'));
        $show->field('candidate_watsupno', __('Candidate WhatsApp Number'));
        $show->field('candidate_email', __('Candidate Email'));
        $show->field('workplace', __('Workplace'));
        $show->field('qualification', __('Qualification'));
        $show->field('remark', __('Remark'));
        $show->field('appointment', __('Appointment'));
        $show->field('appointment_date', __('Appoinment_Date'));
        $show->field('appointment_time', __('Appoinment_Time'));
        $show->field('appointment_note', __('Appoinment_Note'));
       
        return $show;
    }

    protected function form()
    {
          $loginId = Admin::user()->id;
        $form = new Form(new Custregister());

        $form->date('date', __('Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
        $form->time('call_time', __('Calling Time'))->format('h:mm:ss a');

        $form->text('candidate_name', __('Candidate Name'));
        $form->text("fathers_name", __("Father's Name"));
        $form->text("mothers_name", __("Mother's Name"));
        $form->textarea('house_name', __('Address'))->rows(5)->style('width', '300px; height: 150px;');

        $form-> select('country',__('Country'))->options(Country::pluck('name','name'));
         $form-> select('state',__('State'))->options(State::pluck('state_name','state_name'));

        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->radioCard('gender', __('Gender'))->options(['Male' => 'Male', 'Female' => 'Female'])->stacked();
        $form->date('date_of_birth', __('Date of Birth')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY')->setWidth(4, 2);
        $form->hidden('age', __('Age'));
      $form->select('religion', __('Religion'))->options(Religion::pluck('religion','religion'))->setWidth(4, 2);
          $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','cast_name'));
        $form->text('candidate_watsupno', __('Candidate WhatsApp Number'));
        $form->email('candidate_email', __('Candidate Email'));
        $form->text('workplace', __('Workplace'));
        $form->text('qualification', __('Qualification'));
        $form->text('remark', __('Remark'));
        $form->select('datasource', __('Data Source'))->options(['1'=> 'Advertisement','2'=> 'Refferal','3'=> 'Direct','4'=> 'Facebook','5'=>'Instagram','6'=>'Youtube'])
        ->when(2, function (Form $form) {
        $form->text('refferal_name', __('Refferal Name'));
        });
        $form->hidden('task_status', __('task_status'))->default(0);
      
        $form->table('follow_up','Follow up', function ($table) {
               
                $table->text('follow_up')->rules('required');
                $table->datetime('date') ->default(today()->format('d-m-Y H:m'))
    ->format('DD-MM-YYYY')->readonly();
            });

        $form->radioCard('appointment','Appointment')
        ->options([
            1 =>'YES',
            0 =>'NO',
        ])->when(1, function (Form $form) {
           
           $form->date('appointment_date', __('Appointment Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
           $form->time('appointment_time', __('Appointment Time'))->default(date('H:m'));
           $form->textarea('appointment_note', __('Appointment Note'))->rows(5)->style('width', '600px')->style('height', '150px');
    
        })->when(0, function (Form $form) {
            
            $form->hidden('appointment_date', __('Appointment Date'))->default(date(''));
            $form->hidden('appointment_time', __('Appointment Time'))->default(date(''));
            $form->hidden('appointment_note', __('Appointment Note'))->default('');
    
        });
       
         $form->hidden('created_id')->default( $loginId);
        $form->divider();

        $form->saving(function (Form $form) {
        $dateOfBirth = $form->input('date_of_birth');
            if ($dateOfBirth) {
                $dateOfBirth = Carbon::parse($dateOfBirth);
                $age = Carbon::now()->diffInYears($dateOfBirth);
                $form->input('age', $age);
            }
             //$custregister = Custregister::where('appointment', 1)
           // ->where('task_status', 0)->all();
            $custregister = $form->model();

        if ($custregister && $custregister->appointment == 1 && $custregister->task_status == 0) {
            $vca_id = new Visits();
            $vca_id->vca_id = $custregister->id;
            $vca_id->date = $custregister->date;
            $vca_id->candidate_name = $custregister->candidate_name;
            $vca_id->appointment_date = $custregister->appointment_date;
            $vca_id->appointment_time = $custregister->appointment_time;
            $vca_id->appointment_note = $custregister->appointment_note;
            $vca_id->house_name = $custregister->house_name;
            // Save the Visits record
            $vca_id->save();
        }
        });


      
        
    
        return $form;
    }
}