<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Custregister;
use Encore\Admin\Facades\Admin;
use Carbon\Carbon;

class ServiceExecutiveController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Service';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       // $grid = new Grid(new Service());

        
         $grid = new Grid(new Custregister());

         $loginId = Admin::user()->id;  
          
    $grid->model()->where(function ($query) use ($loginId) {
        $query->where('service_assign', $loginId)
              ->where('member_status', 1);
    })->orWhere(function ($query) use ($loginId) {
        $query->where('service_assign', $loginId)
              ->where('member_status', 2);
    });

     
      $grid->column('id', __('ID'));
      $grid->column('candidate_name', __('Candidate Name'));
      $grid->column('fathers_name', __("Father's Name"));
      $grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
      $grid->column('mob_1', __('Mobile 1'));
      $grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
      $grid->column('cast', __('Cast'));
       $grid->column('Details')->display(function (){
           // $id = $this->id;
            
          $user_id = $this->id;
          
           $href_user = 'services/create'.'?user_id='.$user_id;
            
        return "<a href=$href_user>Details</a>";
           
       // return "<a href='services/create'>Details</a>";
        });
       
          $grid->disableCreateButton();

      $grid->actions(function ($actions) {
            $actions->disableEdit();
             $actions->disableView();// Disable the view action
        });

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Service::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('time', __('Time'));
        $show->field('name', __('Name'));
        $show->field('id_number', __('ID Number'));
        $show->field('qualification', __('Qualification'));
        $show->field('occupation', __('Occupation'));
        $show->field('work_place', __('Work Place'));
        $show->field('matching_nam', __('Matching Name'));
        $show->field('m_id_number', __('M ID Number'));
        $show->field('m_qualification', __('M Qualification'));
        $show->field('m_occupation', __('M Occupation'));
        $show->field('m_work_place', __('M Work Place'));
        $show->field('matching_statuss', __('Matching Status'));
        $show->field('status_date_time', __('Status Date & Time'));
        $show->field('meetup_date', __('Meetup Date'));
        $show->field('meetup_status', __('Meetup Status'));
        $show->field('marriage_status', __('Marriage Status'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Service());
        $user_id = intval(request('user_id'));
      // $form = new Form(new Custregister()); // Use the Business model

     
   $form->hidden('cust_id')->value($user_id); // Populate the hidden input field

    $form->radioCard('custmer', __('Custmer'))->options(['1'=> 'Show Details','0'=>'Hide Deatils'])
        ->when(1, function (Form $form) use ($user_id) {

            // Fetch the corresponding Custregister record using the user_id
            $custregisterId = Custregister::find($user_id);

            if ($custregisterId) {
              // $form->embeds('custmer', function ($form) use($custregisterId){
        $form->text('cust_id', __('Id'))->value($custregisterId->id)->setWidth(4, 2)->readonly();       
        $form->text('candidate_name', __('Candidate Name'))->value($custregisterId->candidate_name)->setWidth(4, 2)->readonly();
        $form->text("fathers_name", __("Father's Name"))->value($custregisterId->fathers_name)->setWidth(4, 2)->readonly();
        $form->text("mothers_name", __("Mother's Name"))->value($custregisterId->mothers_name)->setWidth(4, 2)->readonly();
        $form->textarea('house_name', __('Address '))->rows(5)->style('width', '300px; height: 150px;')->value($custregisterId->house_name)->readonly();
        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2)->value($custregisterId->mob_1)->readonly();
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2)->value($custregisterId->mob_2)->readonly();
        $form->date('date_of_birth', __('Date of Birth'))->default(date('Y-m-d'))->setWidth(4, 2)->value($custregisterId->date_of_birth)->readonly();
        $form->text('age', __('Age'))->value($custregisterId->age)->setWidth(4, 2)->readonly();
        $form->text('religion', __('Religion'))->setWidth(4, 2)->value($custregisterId->religion)->readonly();
        $form->text('cast', __('Cast'))->value($custregisterId->cast)->setWidth(4, 2)->readonly();

        
       // });
 }
        });
       $form->table('matching_profile', function ($table) {
        $table->datetime('date', __('Date'))->default(date('d-m-Y H:m'));
        //$table->time('time', __('Time'))->default(date('H:m'));
        $table->text('name', __('Name'));
       // $table->text('id_number', __('ID Number'));
        $table->text('qualification', __('Qualification'));
       // $table->text('occupation', __('Occupation'));
       // $table->text('work_place', __('Work Place'));
       // $table->text('matching_name', __('Matching Name'));
        $table->text('m_id_number', __('M ID Number'));
        $table->text('m_qualification', __('M Qualification'));
        $table->text('m_occupation', __('M Occupation'));
        $table->text('m_work_place', __('M Work Place'));
        $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest']);
       });
        $form->datetime('status_date_time', __('Status Date & Time'))->value(date('Y-m-d H:m'));
        $form->date('meetup_date', __('Meetup Date'));
       $form->select('meetup_status', __('Meetup Status'))->options(['1'=>'Engagement Fix',2=> 'Marriage Fix']);
        $form->date('marriage_date', __('Marriage Date'));
          $form->text('marriage_status', __('Marriage Status'));
        return $form;

    }
}