<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Dataentry;
use App\Models\Users;
use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use App\Models\Package;
use Carbon\Carbon;
use Encore\Admin\Facades\Admin;
use Illuminate\Support\Facades\Hash;

class DataentryController extends AdminController
{
    /**
     * Title for the current resource.
     *
     * @var string
     */
    protected $title = 'Data Entry ';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {

        $grid = new Grid(new Custregister());

         $loginId = Admin::user()->id;  
          
    
     
      $grid->model()->where('data_assign', $loginId);
    
     
      $grid->column('id', __('ID'));
      $grid->column('candidate_name', __('Candidate Name'));
      $grid->column('fathers_name', __("Father's Name"));
      $grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
      $grid->column('mob_1', __('Mobile 1'));
      $grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
      $grid->column('cast', __('Cast'));
      // $grid->column('data_assign', __('Assign To'))->editable('select',(Users::pluck('name','id')));
        // $grid->column('data_remarks', __('Remarks'))->editable('textarea');

    
       // $grid->column('id', __('ID'));
       // $grid->column('date', __('Date'));
       // $grid->column('time', __('Time'));
       // $grid->column('profile_verification',__('Profile Verification'))->display(function ($ProfileVerification) {
          //  if($ProfileVerification ===Constant::STATUS_NO){
          //      return "No";
          //  }else{
           //     return "Yes";
          //  }});
       // $grid->column('registration_d/t', __('Registration Date/Time'));
      //  $grid->column('registration_status', __('Registration status'));
       // $grid->column('pending_reminder', __('Pending Reminder'));
       // $grid->column('wm_id_no', __('WM ID NO'));
       // $grid->column('matching_profile', __('Matching Profile'));
        //$grid->column('date_time', __('Date & Time'));
      //  $grid->column('matching_profile_status', __('Matching Profile Status'));
      //  $grid->column('payment_chance', __('Payment Chance'));
      // $grid->column('payment_reminder', __('Payment Reminder'));
       // $grid->column('member_status', __('Member Status'));
       // $grid->column('plan_details', __('Plan details'));
       // $grid->column('invoice_no', __('Invoice No'));
       // $grid->column('offer_details', __('Offer Details'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Custregister::findOrFail($id));
        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('time', __('Time'));
        $show->field('profile_verification',__('Profile Verification'))->display(function ($ProfileVerification) {
            if($ProfileVerification ===Constant::STATUS_NO){
                return "No";
            }else{
                return "Yes";
            }});
        $show->field('registration_d/t', __('Registration date/Time'));
        $show->field('registration_status', __('Registration status'));
        $show->field('pending_reminder', __('Pending Reminder'));
        $show->field('wm_id_no', __('WM ID NO'));
        $show->field('matching_profile', __('Matching Profile'));
        $show->field('date_time', __('Date & Time'));
        $show->field('matching_profile_status', __('Matching Profile Status'));
        $show->field('payment_chance', __('Payment Chance'));
        $show->field('payment_reminder', __('Payment Reminder'));
        $show->field('member_status', __('Member Status'));
        $show->field('plan_details', __('Plan details'));
        $show->field('invoice_no', __('Invoice No'));
        $show->field('offer_details', __('Offer Details'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Custregister());

        $form->radioCard('custmer', __('Custmer'))->options(['1'=> 'Show Details','0'=>'Hide Deatils'])
     ->when(1, function (Form $form) {
     
        $form->text('candidate_name', __('Candidate Name'));//->value($custregisterId->candidate_name);
        $form->text("fathers_name", __("Father's Name"));//->value($custregisterId->fathers_name);
        $form->text("mothers_name", __("Mother's Name"));//->value($custregisterId->mothers_name);
        $form->textarea('house_name', __('Address '));//->rows(5)->style('width', '300px; height: 150px;')->value($custregisterId->house_name);
        $form->mobile('mob_1', __('First Mobile Number'));//->options(['mask' => '999 999 9999'])->setWidth(4, 2)->value($custregisterId->mob_1);
        $form->mobile('mob_2', __('Second Mobile Number'));//->options(['mask' => '999 999 9999'])->setWidth(4, 2)->value($custregisterId->mob_2);
        $form->date('date_of_birth', __('Date of Birth'));//->default(date('Y-m-d'))->setWidth(4, 2)->value($custregisterId->date_of_birth);
        $form->number('age', __('Age'));//->value($custregisterId->age);
        $form->text('religion', __('Religion'));//->setWidth(4, 2)->value($custregisterId->religion);
        $form->text('cast', __('Cast'));//->value($custregisterId->cast);
         
          })->default(0);

        $form->date('date', __('Date'))->default(date('Y-m-d'));
        $form->time('time', __('Time'))->default(date('H:m'));
        $form->switch('profile_verification', __('Profile Verification'))->states(Constant::STATUS)->default(0);
        $form->datetime('registration_dt', __('Registration Date/Time'))->default(date('Y-m-d H:m'));
       $form->radioCard('registration_status','Ragistration Status')->options([
           
            '1'=> 'YES', '0'=>'PENDING'
            ])
        ->when(1, function(form $form){

        $form->text('wm_id_no', __('WM ID NO'));
       $form->select('payment_chance', __('Payment Chance'))->options([1=>'25%', 2 => '50%',3 =>'75%',4=>'100%'])->setWidth(4, 2);
         $form->radio('member_status', __('Member Status'))->options([
            '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid'
            ])->when (1, function(form $form){

        $form->select('plan_details', __('Plan details'))->options(Package::all()->pluck('name', 'id'));
        $form->text('invoice_no', __('Invoice No'));
        $form->text('offer_details', __('Offer Details'));
         $form->date('payment_reminder', __('Payment Reminder'));

         })->when (2, function(form $form){

          $form->select('plan_details', __('Plan details'))->options(Package::all()->pluck('name', 'id'));
        $form->text('invoice_no', __('Invoice No'));
        $form->text('offer_details', __('Offer Details'));

         })->when (0, function(form $form){
              $form->date('payment_reminder', __('Payment Reminder'));
         })->default(0);

        })->when (0,function(form $form){
           $form->date('pending_reminder', __('Pending Reminder'));
        });
       
        $form->divider();
        
         //$form->text('matching_profile', __('Matching Profile'));
         $form->table('matching_profile','Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required');
                $table->text('matching_profile_name','Matching Profile Name')->rules('required');
                $table->datetime('data_date_time')->default(date('Y-m-d H:m'))->readonly();
            });

        $form->hidden('data_assign', 'Assign_To')->options(Users::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required');
        $form->hidden('data_remarks', __('Remarks'));
         $form->hidden('data_status')->default(intval(2));
        return $form;
    }
    
}