<?php

namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use App\Models\Visits;
use App\Models\Users;
use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Carbon\Carbon;

class VisitassignController extends AdminController
{
    protected $title = 'Visit Assign';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Visits());

        // Define grid columns
        $grid->column('id', __('ID'));
        $grid->column('vca_id', __('Customer ID'));
        $grid->column('date', __('Entry Date'));
        $grid->column('candidate_name', __('Customer Name'));
        $grid->column('appointment_date', __('Appointment Date'));
        $grid->column('appointment_time', __('Appointment Time'));
        $grid->column('appointment_note', __('Appointment Note'));
        $grid->column('house_name', __('Address'));
        $grid->column('assign_to', __('Assign To'))->editable('select',(Users::all()->pluck('name','id')));
        $grid->column('remarks', __('Remarks'))->editable('textarea');
        $grid->column('created_at', __('Created At'));
        $grid->column('updated_at', __('Updated At'));
         $grid->disableCreateButton();

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Visits::findOrFail($id));

        // Define detail view fields
        $show->field('id', __('ID'));
        $show->field('vca_id', __('Customer ID'));
        $show->field('date', __('Entry Date'));
        $show->field('candidate_name', __('Customer Name'));
        $show->field('appointment_date', __('Appointment Date'));
        $show->field('appointment_time', __('Appointment Time'));
        $show->field('appointment_note', __('Appointment Note'));
        $show->field('house_name', __('Address'));
        $show->field('assign_to', __('Aassign To'));
        $show->field('remarks', __('Remarks'));
        $show->field('created_at', __('Created At'));
        $show->field('updated_at', __('Updated At'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Visits());
        $custregister = Custregister::latest('id')->first();
        
        $form->display('vca_id', 'Customer ID')->default($custregister->id);
        $form->display('entry_date', 'Entry Date')->default($custregister->entry_date);
        $form->display('candidate_name', 'Customer Name')->default($custregister->candidate_name);
        $form->date('appointment_date', 'Appointment Date')->default($custregister->appointment_date);
        $form->time('appointment_time', 'Appointment Time')->default($custregister->appointment_time);
        $form->textarea('appointment_note', 'Appointment Note')->default($custregister->appointment_note);
        $form->textarea('remarks', __('Remarks'));
        $form->display('house_name', 'Address')->default($custregister->house_name);
        $form->select('assign_to', 'Assign_To')->options(Users::pluck('name','id'))->setWidth(4, 2)->rules('required');

        $form->saving(function (Form $form) use ($custregister) {
            // Set the vca_id field with the corresponding id from the latest Custregister record
            $form->model()->vca_id = $custregister->id;
            $form->model()->date = $custregister->entry_date;
            $form->model()->candidate_name = $custregister->candidate_name;
            $form->model()->appointment_date = $custregister->appointment_date;
            $form->model()->appointment_time=$custregister->appointment_time;
            $form->model()->appointment_note = $custregister->appointment_note;
            $form->model()->house_name = $custregister->house_name;
        });
        return $form;
    }
}
