<?php

namespace App\Admin\Controllers;

use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Encore\Admin\Filters\Filter;
use Illuminate\Http\Request;
use Encore\Admin\Facades\Admin;
use App\Models\Users;
use App\Models\WorkTracking;
use Encore\Admin\Widgets\Box;
use DB;

class StaffReportsController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Staff wise Report';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
          $grid = new Grid(new Custregister());
                  $grid->header(function ($query) {
            // Retrieve staff name from the WorkTracking table
            $customerData = WorkTracking::select('customer_id', 'user_id')
            ->distinct('customer_id')
            ->get();
        
        $customerCounts = $customerData->groupBy('customer_id')->map(function ($customers) {
            return [
                'count' => $customers->count(),
                'users' => $customers->pluck('user_id')->toArray(),
            ];
        })->toArray();
        
        $userDealCounts = [];
foreach ($customerCounts as $customer) {
    foreach ($customer['users'] as $user) {
        if (isset($userDealCounts[$user])) {
            $userDealCounts[$user]++;
        } else {
            $userDealCounts[$user] = 1;
        }
    }
}
$usernames = Users::whereIn('id', array_keys($userDealCounts))->pluck('name', 'id')->toArray();

// Combine usernames with user deal counts
$userDealCounts = array_map(function($count, $userId) use ($usernames) {
    return [
        'username' => $usernames[$userId],
        'count' => $count
    ];
}, $userDealCounts, array_keys($userDealCounts));
// log::info($userDealCounts);
            return new Box('Staff Graph Report', view('chart.staffreport', compact('userDealCounts')));

        });
 $grid->model()->where('appointment', 1)->where('task_status',0);
     $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
      $grid->column('candidate_name', __('Candidate Name'));
     // $grid->column('fathers_name', __("Father's Name"));
      //$grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
      $grid->column('mob_1', __('Mobile 1'));
      //$grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
      //$grid->column('cast', __('Cast'));

       $grid->filter(function ($filter) {
        $filter->disableIdFilter();
       $filter->equal('work_trackings.user_id', 'Staff Name')->select(Users::pluck('name', 'id'));
          
    $filter->between('created_at', 'Date Range')->date();
    });
    //  if (Admin::user()->inRoles(['Administrator', 'Manager'])) {

    //     $workTrackingData = WorkTracking::with(['customer', 'user'])->get();
    //     $grid->column('Staff Name')->display(function () use ($workTrackingData) {
    //         // Assuming the user relationship is loaded
    //         $userName = $this->user->name; // Assuming 'name' is the field in the 'user' table
    //         return $userName;
    //     });
    
    // }
    
      $grid->disableCreateButton();

      $grid->disableActions();
        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Career::findOrFail($id));
        
       // $show->field('id',__('ID'))->setWidth(4, 2);
        $show->field('jobtitle',__('Job-Title'))->setWidth(4, 2);
        $show->field('description',__('Description'));
        $show->field('Active',__('Active'))->setWidth(2, 2);

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Career());
        
       
        $form->text('jobtitle',__('Job-Title'))->setWidth(4, 2)->rules('required|min:2');
        $form->textarea('description',__('Description'));
        $form->switch('Active',__('Active'))->states(Constant::STATUS)->default(1);
       
        return $form;
    }

}
