<?php

namespace App\Admin\Controllers;

use Illuminate\Support\Facades\Request;
use App\Models\Dataentry;
use App\Models\Users;
use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use App\Models\Package;
use Carbon\Carbon;
use App\Models\Religion;
use App\Models\Cast;
use App\Models\WorkTracking;
use Encore\Admin\Facades\Admin;
use Illuminate\Support\Facades\Hash;


class DataentryController extends AdminController
{
    /**
     * Title for the current resource.
     *
     * @var string
     */
    protected $title = 'Data Entry ';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        
         $request = Request::all();  
       $date=intval(request('d'));
       
        $grid = new Grid(new Custregister());
         
         $loginId = Admin::user()->id;  

         if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->whereNotNull('data_assign');
        }
            else{
            
                $grid->model()->where('data_assign', $loginId);
            }   
       if ($date == 4) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
             $today = now()->toDateString(); 
    $grid->model()->whereDate('payment_reminder', $today);
}
    else{
      $today = now()->toDateString(); 
         $grid->model()->Where('data_assign',$loginId)->whereDate('payment_reminder', $today);
    }     
   }    
   if ($date == 1) {
              if (Admin::user()->inRoles(['Administrator', 'Manager'])){
                   
          $grid->model()->whereNotNull('data_assign')
            ->whereNull('data_status');
      }
          else{
           
               $grid->model()->where('data_assign', $loginId) 
              ->whereNull('data_status');
          }     
         }   
 if ($date == 3) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
             $today = now()->toDateString(); 
    $grid->model()->whereDate('updated_at', $today);
}
    else{
      $today = now()->toDateString(); 
         $grid->model()->Where('data_assign',$loginId)->whereDate('updated_at', $today);
    }     
   }  
    if ($date == 6){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',0);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
       
        $query->where('data_assign', $loginId)
              ->where('data_status', 2)->where('member_status',0);
    });
      }
        }   
        if ($date == 7){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',1);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
      
        $query->where('data_assign', $loginId)
              ->where('data_status', 2)->where('member_status',1);
    });
      }
        }   
       if ($date == 8){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',2);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
       
        $query->where('data_assign', $loginId)
              ->where('data_status', 2)->where('member_status',2);
    });
      }
        }   
    
     $grid->model()->orderBy('id', 'desc');
        $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
$grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        });
  $grid->column('wm_id_no', __('WM ID NO'));
   
      $grid->column('candidate_name', __('Candidate Name'));
      $grid->column('fathers_name', __("Father's Name"));
     // $grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'))->hide();
      $grid->column('place', __('Place/Area'));
      $grid->column('mob_1', __('Mobile 1'));
      $grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'))->hide();
      $grid->column('religion', __('Religion'));
      $grid->column('cast', __('Cast'))->hide();
       
      // $grid->column('data_assign', __('Assign To'))->editable('select',(Users::pluck('name','id')));
        // $grid->column('data_remarks', __('Remarks'))->editable('textarea');

    
       // $grid->column('id', __('ID'));
       // $grid->column('date', __('Date'));
       // $grid->column('time', __('Time'));
       // $grid->column('profile_verification',__('Profile Verification'))->display(function ($ProfileVerification) {
          //  if($ProfileVerification ===Constant::STATUS_NO){
          //      return "No";
          //  }else{
           //     return "Yes";
          //  }});
       // $grid->column('registration_d/t', __('Registration Date/Time'));
      //  $grid->column('registration_status', __('Registration status'));
       // $grid->column('pending_reminder', __('Pending Reminder'));
       // $grid->column('wm_id_no', __('WM ID NO'));
       // $grid->column('matching_profile', __('Matching Profile'));
        //$grid->column('date_time', __('Date & Time'));
      //  $grid->column('matching_profile_status', __('Matching Profile Status'));
      //  $grid->column('payment_chance', __('Payment Chance'));
      // $grid->column('payment_reminder', __('Payment Reminder'));
       // $grid->column('member_status', __('Member Status'));
       // $grid->column('plan_details', __('Plan details'));
       // $grid->column('invoice_no', __('Invoice No'));
       // $grid->column('offer_details', __('Offer Details'));

       $grid->disableCreateButton();
         $grid->actions(function ($actions) {
          
             $actions->disableView();// Disable the view action
        });
        $grid->filter(function ($filter) {
        $filter->disableIdFilter();
        
         
     $filter->in('registration_status','Registration')->radio([
    '1'    => 'Yes',
    '0'    => 'Pending',
]);
       $filter->in('member_status','Payment')->multipleSelect([
    '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid',
            '3' => 'Not Interest'
]);
  
         $filter->like('wm_id_no', __('WM ID NO'));
   
    });
   $grid->quickSearch('date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 'plan_details',
        'qualification','occupation','country','state','place','calling_status','wm_id_no','marital_status');

  if (Admin::user()->inRoles(['Administrator', 'Manager'])){
   // $grid->model()->whereNotNull('created_id');
    $grid->column('user2.name', __('Staff Name'));
}

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Custregister::findOrFail($id));
        //$show->field('id', __('ID'));
       // $show->field('date', __('Date'));
       // $show->field('time', __('Time'));
       // $show->field('profile_verification',__('Profile Verification'))->display(function ($ProfileVerification) {
            //if($ProfileVerification ===Constant::STATUS_NO){
              //  return "No";
           // }else{
              // return "Yes";
          //  }});
        //$show->field('registration_dt', __('Registration date/Time'));
      //  $show->field('registration_status', __('Registration status'));
       // $show->field('pending_reminder', __('Pending Reminder'));
       // $show->field('wm_id_no', __('WM ID NO'));
      //  $show->field('matching_profile', __('Matching Profile'));
     //   $show->field('date_time', __('Date & Time'));
     //   $show->field('matching_profile_status', __('Matching Profile Status'));
       // $show->field('payment_chance', __('Payment Chance'));
      //  $show->field('payment_reminder', __('Payment Reminder'));
      //  $show->field('member_status', __('Member Status'));
      //  $show->field('plan_details', __('Plan details'));
     //   $show->field('invoice_no', __('Invoice No'));
    //    $show->field('offer_details', __('Offer Details'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $loginId = Admin::user()->id;
        $form = new Form(new Custregister());

        $form->radioCard('custmer', __('Custmer'))->options(['1'=> 'Show Details','0'=>'Hide Deatils'])
     ->when(1, function (Form $form) {
     
        $form->text('candidate_name', __('Candidate Name'));//->value($custregisterId->candidate_name);
        $form->text("fathers_name", __("Father's Name"));//->value($custregisterId->fathers_name);
        $form->text("mothers_name", __("Mother's Name"));//->value($custregisterId->mothers_name);
        $form->textarea('house_name', __('Address '));//->rows(5)->style('width', '300px; height: 150px;')->value($custregisterId->house_name);
        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' => '+99 999 999 9999'])->setWidth(4, 2);//->value($custregisterId->mob_1);
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '+99 999 999 9999'])->setWidth(4, 2);
        $form->date('date_of_birth', __('Date of Birth')) ->default(today()->format('d-m-Y'))
         ->format('DD-MM-YYYY');//->default(date('Y-m-d'))->setWidth(4, 2)->value($custregisterId->date_of_birth);
        $form->text('age', __('Age'));//->value($custregisterId->age);
       $form->select('religion', __('Religion'))->options(Religion::pluck('religion','religion'))->setWidth(4, 2);
    //   $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','cast_name'))->setWidth(4, 2);
         $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','id'))->setWidth(4, 2);
              $form->text('qualification', __('Qualification'))->setWidth(4, 2);
          $form->text('occupation', __('Occupation'))->setWidth(4, 2);
        $form->text('workplace', __('Workplace'))->setWidth(4, 2);
           $form->textarea('expectations', __('Expectations'))->setWidth(4, 2);
          })->default(0);

        $form->date('date', __('Profile Entry Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
        $form->time('time', __('Profile Entry Time'))->format('h:mm:ss a');
        $form->switch('profile_verification', __('Profile Verification'))->states(Constant::STATUS)->default(0);
        $form->datetime('registration_dt', __('Registration Date/Time'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
       $form->radioCard('registration_status','Ragistration Status')->options([
           
            '1'=> 'YES', '0'=>'PENDING'
            ])
        ->when(1, function(form $form){

        $form->text('wm_id_no', __('WM ID NO'));
       $form->select('payment_chance', __('Payment Chance'))->options([1=>'25%', 2 => '50%',3 =>'75%',4=>'100%'])->setWidth(4, 2)->rules('required');
         $form->radio('member_status', __('Member Status'))->options([
            '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid',
            '3' => 'Not Interest',
            '4' => 'expired'
            ])->when (1 , function(form $form){

        $form->select('plan_details', __('Plan details'))->options(Package::all()->pluck('name', 'name'));
            $form->select('duration', __('Duration'))->options(Package::all()->pluck('duration', 'duration'));
            $form->dateRange('start_date', 'end_date', 'Start/End Date Range');
        $form->text('invoice_no', __('Invoice No'));
        $form->text('invoice_date', __('Invoice Date'));
        $form->text('offer_details', __('Offer Details'));
         $form->select('payment_mode', __('Payment Mode'))->options([
            '0' => 'Net Banking',
            '1' => ' Bank Transfer', 
            '2' => 'UPI',
            '3' => 'Cash',
            '4' => 'Others'
            ]);
         $form->text('payment_note', __('Payment Note'));
         $form->date('payment_reminder', __('Payment Reminder'))->format('DD-MM-YYYY')->rules('required');
    //      ->default(today()->format('d-m-Y'))
    // ->format('DD-MM-YYYY')->rules('required');

      $form->table('f_matching_profile','Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required');
                $table->text('matching_profile_name','Matching Profile Name')->rules('required');
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
                 $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
            });


         })->when (2, function(form $form){

           $form->select('plan_details', __('Plan details'))->options(Package::all()->pluck('name', 'name'));
            $form->select('duration', __('Duration'))->options(Package::all()->pluck('duration', 'duration'));
            $form->dateRange('start_date', 'end_date', 'Start/End Date Range');
        $form->text('invoice_no', __('Invoice No'));
        $form->date('invoice_date', __('Invoice Date'))->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
        $form->text('offer_details', __('Offer Details'));
         $form->select('payment_mode', __('Payment Mode'))->options([
            '0' => 'Net Banking',
            '1' => ' Bank Transfer', 
            '2' => 'UPI',
            '3' => 'Cash',
            '4' => 'Others'
            ]);
         $form->text('payment_note', __('Payment Note'));
          


         })->when (0, function(form $form){
              $form->date('payment_reminder', __('Payment Reminder'))->rules('required');
               $form->text('payment_note', __('Payment Note'));
            $form->table('matching_profile','Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required');
                $table->text('matching_profile_name','Matching Profile Name')->rules('required');
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
                 $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
            });
         });

        })->when (0,function(form $form){
           $form->date('pending_reminder', __('Pending Reminder')) ->default(today()->format('d-m-Y'))->format('DD-MM-YYYY');
        });
       
        $form->divider();
        
         //$form->text('matching_profile', __('Matching Profile'));
       
       // $form->hidden('created_by', $loginId);
         $form->hidden('data_status')->default(intval(2));
         
         $form->saving(function (Form $form) {
        $dateOfBirth = $form->input('date_of_birth');
            if ($dateOfBirth) {
                $dateOfBirth = Carbon::parse($dateOfBirth);
                $age = Carbon::now()->diffInYears($dateOfBirth);
                $form->input('age', $age);
            }
             //$custregister = Custregister::where('appointment', 1)
           // ->where('task_status', 0)->all();
            $custregister = $form->model()->id;
            $role = Admin::user()->roles;
            
              $loginId = Admin::user()->id;
               $form->model()->created_by = $loginId;

        if ($custregister && $role) {
    // Assuming that $roles is a collection of roles
    $roleNames = $role->pluck('name')->implode(', ');

            $tracks = new WorkTracking();
            $tracks->customer_id = $custregister;
            $tracks->user_id =  $loginId;
            $tracks->role_name =  $roleNames;
          
            // Save the Visits record
            $tracks->save();
        }
            
        });
         $form->tools(function (Form\Tools $tools) {

                 
    // Disable `Veiw` btn.
    $tools->disableView();

  
});
 if (Admin::user()->inRoles(['Administrator', 'Manager'])){
          // $grid->model()->whereNotNull('created_id');
          $form->list('adm_followup',__('Admin FollowUp'));
       }
      return $form;

    $form->saving(function (Form $form) {
    $payment = $form->model(); // Assuming the form model is linked to the Custregister model
    
    
    $inputPaymentReminder = $payment['payment_reminder'];

    $dateInput = \Carbon\Carbon::createFromFormat('d-m-Y', $inputPaymentReminder);

   
    $formattedPaymentReminder = $dateInput->format('Y-m-d H:i:s');
    
   
    $payment->payment_reminder = $formattedPaymentReminder;
});

    
  }
}