<?php

namespace App\Admin\Controllers;

use App\Models\Custregister;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Encore\Admin\Filters\Filter;
use Illuminate\Http\Request;
use Encore\Admin\Facades\Admin;
use DB;

class CustmerReportsController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Customer wise Report';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {

          $href_user= env('APP_URL')."admin/custreports";

          $grid = new Grid(new Custregister());

         $loginId = Admin::user()->id;

if (Admin::user()->inRoles(['Administrator', 'Manager'])) {
    $grid->model()->whereNotNull('created_id');
} else {
    $grid->model()->whereHas('work_trackings', function ($query) use ($loginId) {
        $query->where('user_id', $loginId);
    });
}
       
      $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
      $grid->column('Name')->display(function () use($href_user){
            $id = $this->id;
            $user_name =  $this->candidate_name;
            //  $href_user = $href_user.$id ;
        return "<a href='custreports/$id?'target='_blank' rel='nooper'> $user_name</a>";
        });
     // $grid->column('fathers_name', __("Father's Name"));
      //$grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
      $grid->column('mob_1', __('Mobile 1'));
      //$grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
      $grid->column('cast', __('Cast'));
        $grid->column('appointment_date', __('Appointment'));
       $grid->column('visits_status', __('Visited'))->display(function ($home) {
           if($home == 1){
               return "Yes";
           }else{
               return "No";
           }
        });
      
      $grid->column('registration_status',__('Registration'))->display(function ($home) {
           if($home == 1){
               return "Yes";
           }else{
              return "PENDING"; 
           }
        });

      $grid->column('member_status', __('Payment'))->display(function ($home) {
           switch ($home) {
        case 0:
            return "Free";
        case 1:
            return "Advance";
        case 2:
            return "Paid";
        default:
            return "Unknown"; // Handle any other values, if necessary
    }
      });
        $grid->column('invoice_no', __('Invoice No'));
         $grid->column('invoice_date', __('Invoice Date'));
       

      $grid->column('plan_details', __('Plan details'));
     

       $grid->filter(function ($filter) {
        $filter->disableIdFilter();
        $filter->expand();

        // Check if the "Show All" button is clicked
        if (request()->get('_clear')) {
            // Clear all filters
            $filter->reset();
       }
    $filter->column(1/2, function ($filter) {      
    $filter->between('created_at', 'Date Range')->date();

    
     $filter->in('registration_status','Registration')->radio([
    '1'    => 'Yes',
    '0'    => 'Pending',
]);
 });
   $filter->column(1/2, function ($filter) {      
 $filter->in('appointment')->radio([
    '1'    => 'Yes',
    '0'    => 'No',
]);
   

        $filter->in('member_status','Payment')->multipleSelect([
    '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid',
            '3' => 'Not Interest'
]);
   });
    });
    
    

    $grid->disableActions();
   
      $grid->disableCreateButton();

      $grid->actions(function ($actions) {
            $actions->disableEdit();
             $actions->disableView();// Disable the view action
                 $actions->disableDelete();
                 
        });
    

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Custregister::findOrFail($id));
      //  $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('call_time', __('Call Time'));
        $show->field('candidate_name', __('Candidate Name'));
        $show->field('fathers_name', __("Father's Name"));
        $show->field('mothers_name', __("Mother's Name"));
        $show->field('house_name', __('House Name'));
        $show->field('mob_1', __('Mobile 1'));
        $show->field('mob_2', __('Mobile 2'));
        $show->field('gender', __('Gender'));
        $show->field('date_of_birth', __('Date of Birth'));
        $show->field('religion', __('Religion'));
        $show->field('cast', __('Cast'));
        $show->field('candidate_watsupno', __('Candidate WhatsApp Number'));
        $show->field('candidate_email', __('Candidate Email'));
        $show->field('workplace', __('Workplace'));
        $show->field('qualification', __('Qualification'));
        $show->field('remark', __('Remark'));
        $show->field('appointment', __('Appointment'));
        $show->field('appointment_date', __('Appoinment_Date'));
        $show->field('appointment_time', __('Appoinment_Time'));
        $show->field('appointment_note', __('Appoinment_Note'));
        $show->field('plan_details', __('Plan details'));
        $show->field('payment_chance', __('Payment Chance'));
        $show->field('plan_details', __('Plan details'));
        $show->field('offer_details', __('Offer Details'));
        $show->field('invoice_no', __('Invoice No'));
        $show->field('payment_reminder', __('Payment Reminder'));
        $show->field('marriage_date', __('Marriage Date'));
        $show->field('marriage_status', __('Marriage Status'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Career());
        
       
        $form->text('jobtitle',__('Job-Title'))->setWidth(4, 2)->rules('required|min:2');
        $form->textarea('description',__('Description'));
        $form->switch('Active',__('Active'))->states(Constant::STATUS)->default(1);
       
        return $form;
    }

}
